/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.CertificateLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Certificate
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="deploymentId")
    private final String deploymentId;
    @JsonProperty(value="certificateContent")
    private final String certificateContent;
    @JsonProperty(value="issuer")
    private final String issuer;
    @JsonProperty(value="isSelfSigned")
    private final Boolean isSelfSigned;
    @JsonProperty(value="md5Hash")
    private final String md5Hash;
    @JsonProperty(value="publicKey")
    private final String publicKey;
    @JsonProperty(value="publicKeyAlgorithm")
    private final String publicKeyAlgorithm;
    @JsonProperty(value="publicKeySize")
    private final Long publicKeySize;
    @JsonProperty(value="serial")
    private final String serial;
    @JsonProperty(value="subject")
    private final String subject;
    @JsonProperty(value="timeValidFrom")
    private final Date timeValidFrom;
    @JsonProperty(value="timeValidTo")
    private final Date timeValidTo;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="sha1Hash")
    private final String sha1Hash;
    @JsonProperty(value="authorityKeyId")
    private final String authorityKeyId;
    @JsonProperty(value="isCa")
    private final Boolean isCa;
    @JsonProperty(value="subjectKeyId")
    private final String subjectKeyId;
    @JsonProperty(value="lifecycleState")
    private final CertificateLifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"key", "deploymentId", "certificateContent", "issuer", "isSelfSigned", "md5Hash", "publicKey", "publicKeyAlgorithm", "publicKeySize", "serial", "subject", "timeValidFrom", "timeValidTo", "version", "sha1Hash", "authorityKeyId", "isCa", "subjectKeyId", "lifecycleState", "timeCreated"})
    public Certificate(String key, String deploymentId, String certificateContent, String issuer, Boolean isSelfSigned, String md5Hash, String publicKey, String publicKeyAlgorithm, Long publicKeySize, String serial, String subject, Date timeValidFrom, Date timeValidTo, String version, String sha1Hash, String authorityKeyId, Boolean isCa, String subjectKeyId, CertificateLifecycleState lifecycleState, Date timeCreated) {
        this.key = key;
        this.deploymentId = deploymentId;
        this.certificateContent = certificateContent;
        this.issuer = issuer;
        this.isSelfSigned = isSelfSigned;
        this.md5Hash = md5Hash;
        this.publicKey = publicKey;
        this.publicKeyAlgorithm = publicKeyAlgorithm;
        this.publicKeySize = publicKeySize;
        this.serial = serial;
        this.subject = subject;
        this.timeValidFrom = timeValidFrom;
        this.timeValidTo = timeValidTo;
        this.version = version;
        this.sha1Hash = sha1Hash;
        this.authorityKeyId = authorityKeyId;
        this.isCa = isCa;
        this.subjectKeyId = subjectKeyId;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getCertificateContent() {
        return this.certificateContent;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public Boolean getIsSelfSigned() {
        return this.isSelfSigned;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyAlgorithm() {
        return this.publicKeyAlgorithm;
    }

    public Long getPublicKeySize() {
        return this.publicKeySize;
    }

    public String getSerial() {
        return this.serial;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getTimeValidFrom() {
        return this.timeValidFrom;
    }

    public Date getTimeValidTo() {
        return this.timeValidTo;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSha1Hash() {
        return this.sha1Hash;
    }

    public String getAuthorityKeyId() {
        return this.authorityKeyId;
    }

    public Boolean getIsCa() {
        return this.isCa;
    }

    public String getSubjectKeyId() {
        return this.subjectKeyId;
    }

    public CertificateLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", deploymentId=").append(String.valueOf(this.deploymentId));
        sb.append(", certificateContent=").append(String.valueOf(this.certificateContent));
        sb.append(", issuer=").append(String.valueOf(this.issuer));
        sb.append(", isSelfSigned=").append(String.valueOf(this.isSelfSigned));
        sb.append(", md5Hash=").append(String.valueOf(this.md5Hash));
        sb.append(", publicKey=").append(String.valueOf(this.publicKey));
        sb.append(", publicKeyAlgorithm=").append(String.valueOf(this.publicKeyAlgorithm));
        sb.append(", publicKeySize=").append(String.valueOf(this.publicKeySize));
        sb.append(", serial=").append(String.valueOf(this.serial));
        sb.append(", subject=").append(String.valueOf(this.subject));
        sb.append(", timeValidFrom=").append(String.valueOf(this.timeValidFrom));
        sb.append(", timeValidTo=").append(String.valueOf(this.timeValidTo));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", sha1Hash=").append(String.valueOf(this.sha1Hash));
        sb.append(", authorityKeyId=").append(String.valueOf(this.authorityKeyId));
        sb.append(", isCa=").append(String.valueOf(this.isCa));
        sb.append(", subjectKeyId=").append(String.valueOf(this.subjectKeyId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals(this.certificateContent, other.certificateContent) && Objects.equals(this.issuer, other.issuer) && Objects.equals(this.isSelfSigned, other.isSelfSigned) && Objects.equals(this.md5Hash, other.md5Hash) && Objects.equals(this.publicKey, other.publicKey) && Objects.equals(this.publicKeyAlgorithm, other.publicKeyAlgorithm) && Objects.equals(this.publicKeySize, other.publicKeySize) && Objects.equals(this.serial, other.serial) && Objects.equals(this.subject, other.subject) && Objects.equals(this.timeValidFrom, other.timeValidFrom) && Objects.equals(this.timeValidTo, other.timeValidTo) && Objects.equals(this.version, other.version) && Objects.equals(this.sha1Hash, other.sha1Hash) && Objects.equals(this.authorityKeyId, other.authorityKeyId) && Objects.equals(this.isCa, other.isCa) && Objects.equals(this.subjectKeyId, other.subjectKeyId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.deploymentId == null ? 43 : this.deploymentId.hashCode());
        result = result * 59 + (this.certificateContent == null ? 43 : this.certificateContent.hashCode());
        result = result * 59 + (this.issuer == null ? 43 : this.issuer.hashCode());
        result = result * 59 + (this.isSelfSigned == null ? 43 : this.isSelfSigned.hashCode());
        result = result * 59 + (this.md5Hash == null ? 43 : this.md5Hash.hashCode());
        result = result * 59 + (this.publicKey == null ? 43 : this.publicKey.hashCode());
        result = result * 59 + (this.publicKeyAlgorithm == null ? 43 : this.publicKeyAlgorithm.hashCode());
        result = result * 59 + (this.publicKeySize == null ? 43 : this.publicKeySize.hashCode());
        result = result * 59 + (this.serial == null ? 43 : this.serial.hashCode());
        result = result * 59 + (this.subject == null ? 43 : this.subject.hashCode());
        result = result * 59 + (this.timeValidFrom == null ? 43 : this.timeValidFrom.hashCode());
        result = result * 59 + (this.timeValidTo == null ? 43 : this.timeValidTo.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.sha1Hash == null ? 43 : this.sha1Hash.hashCode());
        result = result * 59 + (this.authorityKeyId == null ? 43 : this.authorityKeyId.hashCode());
        result = result * 59 + (this.isCa == null ? 43 : this.isCa.hashCode());
        result = result * 59 + (this.subjectKeyId == null ? 43 : this.subjectKeyId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="deploymentId")
        private String deploymentId;
        @JsonProperty(value="certificateContent")
        private String certificateContent;
        @JsonProperty(value="issuer")
        private String issuer;
        @JsonProperty(value="isSelfSigned")
        private Boolean isSelfSigned;
        @JsonProperty(value="md5Hash")
        private String md5Hash;
        @JsonProperty(value="publicKey")
        private String publicKey;
        @JsonProperty(value="publicKeyAlgorithm")
        private String publicKeyAlgorithm;
        @JsonProperty(value="publicKeySize")
        private Long publicKeySize;
        @JsonProperty(value="serial")
        private String serial;
        @JsonProperty(value="subject")
        private String subject;
        @JsonProperty(value="timeValidFrom")
        private Date timeValidFrom;
        @JsonProperty(value="timeValidTo")
        private Date timeValidTo;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="sha1Hash")
        private String sha1Hash;
        @JsonProperty(value="authorityKeyId")
        private String authorityKeyId;
        @JsonProperty(value="isCa")
        private Boolean isCa;
        @JsonProperty(value="subjectKeyId")
        private String subjectKeyId;
        @JsonProperty(value="lifecycleState")
        private CertificateLifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            this.__explicitlySet__.add("deploymentId");
            return this;
        }

        public Builder certificateContent(String certificateContent) {
            this.certificateContent = certificateContent;
            this.__explicitlySet__.add("certificateContent");
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            this.__explicitlySet__.add("issuer");
            return this;
        }

        public Builder isSelfSigned(Boolean isSelfSigned) {
            this.isSelfSigned = isSelfSigned;
            this.__explicitlySet__.add("isSelfSigned");
            return this;
        }

        public Builder md5Hash(String md5Hash) {
            this.md5Hash = md5Hash;
            this.__explicitlySet__.add("md5Hash");
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.__explicitlySet__.add("publicKey");
            return this;
        }

        public Builder publicKeyAlgorithm(String publicKeyAlgorithm) {
            this.publicKeyAlgorithm = publicKeyAlgorithm;
            this.__explicitlySet__.add("publicKeyAlgorithm");
            return this;
        }

        public Builder publicKeySize(Long publicKeySize) {
            this.publicKeySize = publicKeySize;
            this.__explicitlySet__.add("publicKeySize");
            return this;
        }

        public Builder serial(String serial) {
            this.serial = serial;
            this.__explicitlySet__.add("serial");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.__explicitlySet__.add("subject");
            return this;
        }

        public Builder timeValidFrom(Date timeValidFrom) {
            this.timeValidFrom = timeValidFrom;
            this.__explicitlySet__.add("timeValidFrom");
            return this;
        }

        public Builder timeValidTo(Date timeValidTo) {
            this.timeValidTo = timeValidTo;
            this.__explicitlySet__.add("timeValidTo");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder sha1Hash(String sha1Hash) {
            this.sha1Hash = sha1Hash;
            this.__explicitlySet__.add("sha1Hash");
            return this;
        }

        public Builder authorityKeyId(String authorityKeyId) {
            this.authorityKeyId = authorityKeyId;
            this.__explicitlySet__.add("authorityKeyId");
            return this;
        }

        public Builder isCa(Boolean isCa) {
            this.isCa = isCa;
            this.__explicitlySet__.add("isCa");
            return this;
        }

        public Builder subjectKeyId(String subjectKeyId) {
            this.subjectKeyId = subjectKeyId;
            this.__explicitlySet__.add("subjectKeyId");
            return this;
        }

        public Builder lifecycleState(CertificateLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Certificate build() {
            Certificate model = new Certificate(this.key, this.deploymentId, this.certificateContent, this.issuer, this.isSelfSigned, this.md5Hash, this.publicKey, this.publicKeyAlgorithm, this.publicKeySize, this.serial, this.subject, this.timeValidFrom, this.timeValidTo, this.version, this.sha1Hash, this.authorityKeyId, this.isCa, this.subjectKeyId, this.lifecycleState, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Certificate model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("deploymentId")) {
                this.deploymentId(model.getDeploymentId());
            }
            if (model.wasPropertyExplicitlySet("certificateContent")) {
                this.certificateContent(model.getCertificateContent());
            }
            if (model.wasPropertyExplicitlySet("issuer")) {
                this.issuer(model.getIssuer());
            }
            if (model.wasPropertyExplicitlySet("isSelfSigned")) {
                this.isSelfSigned(model.getIsSelfSigned());
            }
            if (model.wasPropertyExplicitlySet("md5Hash")) {
                this.md5Hash(model.getMd5Hash());
            }
            if (model.wasPropertyExplicitlySet("publicKey")) {
                this.publicKey(model.getPublicKey());
            }
            if (model.wasPropertyExplicitlySet("publicKeyAlgorithm")) {
                this.publicKeyAlgorithm(model.getPublicKeyAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("publicKeySize")) {
                this.publicKeySize(model.getPublicKeySize());
            }
            if (model.wasPropertyExplicitlySet("serial")) {
                this.serial(model.getSerial());
            }
            if (model.wasPropertyExplicitlySet("subject")) {
                this.subject(model.getSubject());
            }
            if (model.wasPropertyExplicitlySet("timeValidFrom")) {
                this.timeValidFrom(model.getTimeValidFrom());
            }
            if (model.wasPropertyExplicitlySet("timeValidTo")) {
                this.timeValidTo(model.getTimeValidTo());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("sha1Hash")) {
                this.sha1Hash(model.getSha1Hash());
            }
            if (model.wasPropertyExplicitlySet("authorityKeyId")) {
                this.authorityKeyId(model.getAuthorityKeyId());
            }
            if (model.wasPropertyExplicitlySet("isCa")) {
                this.isCa(model.getIsCa());
            }
            if (model.wasPropertyExplicitlySet("subjectKeyId")) {
                this.subjectKeyId(model.getSubjectKeyId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

