/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.AddResourceLockDetails;
import com.oracle.bmc.goldengate.model.CreateConnectionDetails;
import com.oracle.bmc.goldengate.model.Db2Connection;
import com.oracle.bmc.goldengate.model.NameValuePair;
import com.oracle.bmc.goldengate.model.RoutingMethod;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateDb2ConnectionDetails
extends CreateConnectionDetails {
    @JsonProperty(value="technologyType")
    private final Db2Connection.TechnologyType technologyType;
    @JsonProperty(value="databaseName")
    private final String databaseName;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="additionalAttributes")
    private final List<NameValuePair> additionalAttributes;
    @JsonProperty(value="securityProtocol")
    private final Db2Connection.SecurityProtocol securityProtocol;
    @JsonProperty(value="sslClientKeystoredb")
    private final String sslClientKeystoredb;
    @JsonProperty(value="sslClientKeystash")
    private final String sslClientKeystash;
    @JsonProperty(value="sslServerCertificate")
    private final String sslServerCertificate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateDb2ConnectionDetails(String displayName, String description, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<AddResourceLockDetails> locks, String vaultId, String keyId, List<String> nsgIds, String subnetId, RoutingMethod routingMethod, Db2Connection.TechnologyType technologyType, String databaseName, String host, Integer port, String username, String password, List<NameValuePair> additionalAttributes, Db2Connection.SecurityProtocol securityProtocol, String sslClientKeystoredb, String sslClientKeystash, String sslServerCertificate) {
        super(displayName, description, compartmentId, freeformTags, definedTags, locks, vaultId, keyId, nsgIds, subnetId, routingMethod);
        this.technologyType = technologyType;
        this.databaseName = databaseName;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.additionalAttributes = additionalAttributes;
        this.securityProtocol = securityProtocol;
        this.sslClientKeystoredb = sslClientKeystoredb;
        this.sslClientKeystash = sslClientKeystash;
        this.sslServerCertificate = sslServerCertificate;
    }

    public Db2Connection.TechnologyType getTechnologyType() {
        return this.technologyType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<NameValuePair> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public Db2Connection.SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getSslClientKeystoredb() {
        return this.sslClientKeystoredb;
    }

    public String getSslClientKeystash() {
        return this.sslClientKeystash;
    }

    public String getSslServerCertificate() {
        return this.sslServerCertificate;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDb2ConnectionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", technologyType=").append(String.valueOf((Object)this.technologyType));
        sb.append(", databaseName=").append(String.valueOf(this.databaseName));
        sb.append(", host=").append(String.valueOf(this.host));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", password=").append("<redacted>");
        sb.append(", additionalAttributes=").append(String.valueOf(this.additionalAttributes));
        sb.append(", securityProtocol=").append(String.valueOf((Object)this.securityProtocol));
        sb.append(", sslClientKeystoredb=").append(String.valueOf(this.sslClientKeystoredb));
        sb.append(", sslClientKeystash=").append(String.valueOf(this.sslClientKeystash));
        sb.append(", sslServerCertificate=").append(String.valueOf(this.sslServerCertificate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDb2ConnectionDetails)) {
            return false;
        }
        CreateDb2ConnectionDetails other = (CreateDb2ConnectionDetails)((Object)o);
        return Objects.equals((Object)this.technologyType, (Object)other.technologyType) && Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.additionalAttributes, other.additionalAttributes) && Objects.equals((Object)this.securityProtocol, (Object)other.securityProtocol) && Objects.equals(this.sslClientKeystoredb, other.sslClientKeystoredb) && Objects.equals(this.sslClientKeystash, other.sslClientKeystash) && Objects.equals(this.sslServerCertificate, other.sslServerCertificate) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.technologyType == null ? 43 : this.technologyType.hashCode());
        result = result * 59 + (this.databaseName == null ? 43 : this.databaseName.hashCode());
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.additionalAttributes == null ? 43 : this.additionalAttributes.hashCode());
        result = result * 59 + (this.securityProtocol == null ? 43 : this.securityProtocol.hashCode());
        result = result * 59 + (this.sslClientKeystoredb == null ? 43 : this.sslClientKeystoredb.hashCode());
        result = result * 59 + (this.sslClientKeystash == null ? 43 : this.sslClientKeystash.hashCode());
        result = result * 59 + (this.sslServerCertificate == null ? 43 : this.sslServerCertificate.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="locks")
        private List<AddResourceLockDetails> locks;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="routingMethod")
        private RoutingMethod routingMethod;
        @JsonProperty(value="technologyType")
        private Db2Connection.TechnologyType technologyType;
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="additionalAttributes")
        private List<NameValuePair> additionalAttributes;
        @JsonProperty(value="securityProtocol")
        private Db2Connection.SecurityProtocol securityProtocol;
        @JsonProperty(value="sslClientKeystoredb")
        private String sslClientKeystoredb;
        @JsonProperty(value="sslClientKeystash")
        private String sslClientKeystash;
        @JsonProperty(value="sslServerCertificate")
        private String sslServerCertificate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder locks(List<AddResourceLockDetails> locks) {
            this.locks = locks;
            this.__explicitlySet__.add("locks");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder routingMethod(RoutingMethod routingMethod) {
            this.routingMethod = routingMethod;
            this.__explicitlySet__.add("routingMethod");
            return this;
        }

        public Builder technologyType(Db2Connection.TechnologyType technologyType) {
            this.technologyType = technologyType;
            this.__explicitlySet__.add("technologyType");
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder additionalAttributes(List<NameValuePair> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            this.__explicitlySet__.add("additionalAttributes");
            return this;
        }

        public Builder securityProtocol(Db2Connection.SecurityProtocol securityProtocol) {
            this.securityProtocol = securityProtocol;
            this.__explicitlySet__.add("securityProtocol");
            return this;
        }

        public Builder sslClientKeystoredb(String sslClientKeystoredb) {
            this.sslClientKeystoredb = sslClientKeystoredb;
            this.__explicitlySet__.add("sslClientKeystoredb");
            return this;
        }

        public Builder sslClientKeystash(String sslClientKeystash) {
            this.sslClientKeystash = sslClientKeystash;
            this.__explicitlySet__.add("sslClientKeystash");
            return this;
        }

        public Builder sslServerCertificate(String sslServerCertificate) {
            this.sslServerCertificate = sslServerCertificate;
            this.__explicitlySet__.add("sslServerCertificate");
            return this;
        }

        public CreateDb2ConnectionDetails build() {
            CreateDb2ConnectionDetails model = new CreateDb2ConnectionDetails(this.displayName, this.description, this.compartmentId, this.freeformTags, this.definedTags, this.locks, this.vaultId, this.keyId, this.nsgIds, this.subnetId, this.routingMethod, this.technologyType, this.databaseName, this.host, this.port, this.username, this.password, this.additionalAttributes, this.securityProtocol, this.sslClientKeystoredb, this.sslClientKeystash, this.sslServerCertificate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDb2ConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("locks")) {
                this.locks(model.getLocks());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("routingMethod")) {
                this.routingMethod(model.getRoutingMethod());
            }
            if (model.wasPropertyExplicitlySet("technologyType")) {
                this.technologyType(model.getTechnologyType());
            }
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("additionalAttributes")) {
                this.additionalAttributes(model.getAdditionalAttributes());
            }
            if (model.wasPropertyExplicitlySet("securityProtocol")) {
                this.securityProtocol(model.getSecurityProtocol());
            }
            if (model.wasPropertyExplicitlySet("sslClientKeystoredb")) {
                this.sslClientKeystoredb(model.getSslClientKeystoredb());
            }
            if (model.wasPropertyExplicitlySet("sslClientKeystash")) {
                this.sslClientKeystash(model.getSslClientKeystash());
            }
            if (model.wasPropertyExplicitlySet("sslServerCertificate")) {
                this.sslServerCertificate(model.getSslServerCertificate());
            }
            return this;
        }
    }
}

