/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.ElasticsearchConnection;
import com.oracle.bmc.goldengate.model.RoutingMethod;
import com.oracle.bmc.goldengate.model.UpdateConnectionDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateElasticsearchConnectionDetails
extends UpdateConnectionDetails {
    @JsonProperty(value="servers")
    private final String servers;
    @JsonProperty(value="securityProtocol")
    private final ElasticsearchConnection.SecurityProtocol securityProtocol;
    @JsonProperty(value="authenticationType")
    private final ElasticsearchConnection.AuthenticationType authenticationType;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="fingerprint")
    private final String fingerprint;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateElasticsearchConnectionDetails(String displayName, String description, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String vaultId, String keyId, List<String> nsgIds, String subnetId, RoutingMethod routingMethod, String servers, ElasticsearchConnection.SecurityProtocol securityProtocol, ElasticsearchConnection.AuthenticationType authenticationType, String username, String password, String fingerprint) {
        super(displayName, description, freeformTags, definedTags, vaultId, keyId, nsgIds, subnetId, routingMethod);
        this.servers = servers;
        this.securityProtocol = securityProtocol;
        this.authenticationType = authenticationType;
        this.username = username;
        this.password = password;
        this.fingerprint = fingerprint;
    }

    public String getServers() {
        return this.servers;
    }

    public ElasticsearchConnection.SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public ElasticsearchConnection.AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateElasticsearchConnectionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", servers=").append(String.valueOf(this.servers));
        sb.append(", securityProtocol=").append(String.valueOf((Object)this.securityProtocol));
        sb.append(", authenticationType=").append(String.valueOf((Object)this.authenticationType));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", password=").append("<redacted>");
        sb.append(", fingerprint=").append(String.valueOf(this.fingerprint));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateElasticsearchConnectionDetails)) {
            return false;
        }
        UpdateElasticsearchConnectionDetails other = (UpdateElasticsearchConnectionDetails)((Object)o);
        return Objects.equals(this.servers, other.servers) && Objects.equals((Object)this.securityProtocol, (Object)other.securityProtocol) && Objects.equals((Object)this.authenticationType, (Object)other.authenticationType) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.fingerprint, other.fingerprint) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.servers == null ? 43 : this.servers.hashCode());
        result = result * 59 + (this.securityProtocol == null ? 43 : this.securityProtocol.hashCode());
        result = result * 59 + (this.authenticationType == null ? 43 : this.authenticationType.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.fingerprint == null ? 43 : this.fingerprint.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="routingMethod")
        private RoutingMethod routingMethod;
        @JsonProperty(value="servers")
        private String servers;
        @JsonProperty(value="securityProtocol")
        private ElasticsearchConnection.SecurityProtocol securityProtocol;
        @JsonProperty(value="authenticationType")
        private ElasticsearchConnection.AuthenticationType authenticationType;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="fingerprint")
        private String fingerprint;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder routingMethod(RoutingMethod routingMethod) {
            this.routingMethod = routingMethod;
            this.__explicitlySet__.add("routingMethod");
            return this;
        }

        public Builder servers(String servers) {
            this.servers = servers;
            this.__explicitlySet__.add("servers");
            return this;
        }

        public Builder securityProtocol(ElasticsearchConnection.SecurityProtocol securityProtocol) {
            this.securityProtocol = securityProtocol;
            this.__explicitlySet__.add("securityProtocol");
            return this;
        }

        public Builder authenticationType(ElasticsearchConnection.AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            this.__explicitlySet__.add("authenticationType");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            this.__explicitlySet__.add("fingerprint");
            return this;
        }

        public UpdateElasticsearchConnectionDetails build() {
            UpdateElasticsearchConnectionDetails model = new UpdateElasticsearchConnectionDetails(this.displayName, this.description, this.freeformTags, this.definedTags, this.vaultId, this.keyId, this.nsgIds, this.subnetId, this.routingMethod, this.servers, this.securityProtocol, this.authenticationType, this.username, this.password, this.fingerprint);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateElasticsearchConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("routingMethod")) {
                this.routingMethod(model.getRoutingMethod());
            }
            if (model.wasPropertyExplicitlySet("servers")) {
                this.servers(model.getServers());
            }
            if (model.wasPropertyExplicitlySet("securityProtocol")) {
                this.securityProtocol(model.getSecurityProtocol());
            }
            if (model.wasPropertyExplicitlySet("authenticationType")) {
                this.authenticationType(model.getAuthenticationType());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("fingerprint")) {
                this.fingerprint(model.getFingerprint());
            }
            return this;
        }
    }
}

