/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.goldengate.model.StartDeploymentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class StartDeploymentRequest
extends BmcRequest<StartDeploymentDetails> {
    private String deploymentId;
    private StartDeploymentDetails startDeploymentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;
    private Boolean isLockOverride;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public StartDeploymentDetails getStartDeploymentDetails() {
        return this.startDeploymentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Boolean getIsLockOverride() {
        return this.isLockOverride;
    }

    @InternalSdk
    public StartDeploymentDetails getBody$() {
        return this.startDeploymentDetails;
    }

    public Builder toBuilder() {
        return new Builder().deploymentId(this.deploymentId).startDeploymentDetails(this.startDeploymentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).isLockOverride(this.isLockOverride);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",deploymentId=").append(String.valueOf(this.deploymentId));
        sb.append(",startDeploymentDetails=").append(String.valueOf((Object)this.startDeploymentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",isLockOverride=").append(String.valueOf(this.isLockOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StartDeploymentRequest)) {
            return false;
        }
        StartDeploymentRequest other = (StartDeploymentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals((Object)this.startDeploymentDetails, (Object)other.startDeploymentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.isLockOverride, other.isLockOverride);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deploymentId == null ? 43 : this.deploymentId.hashCode());
        result = result * 59 + (this.startDeploymentDetails == null ? 43 : this.startDeploymentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.isLockOverride == null ? 43 : this.isLockOverride.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<StartDeploymentRequest, StartDeploymentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String deploymentId = null;
        private StartDeploymentDetails startDeploymentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private Boolean isLockOverride = null;

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder startDeploymentDetails(StartDeploymentDetails startDeploymentDetails) {
            this.startDeploymentDetails = startDeploymentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder isLockOverride(Boolean isLockOverride) {
            this.isLockOverride = isLockOverride;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(StartDeploymentRequest o) {
            this.deploymentId(o.getDeploymentId());
            this.startDeploymentDetails(o.getStartDeploymentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.isLockOverride(o.getIsLockOverride());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public StartDeploymentRequest build() {
            StartDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(StartDeploymentDetails body) {
            this.startDeploymentDetails(body);
            return this;
        }

        public StartDeploymentRequest buildWithoutInvocationCallback() {
            StartDeploymentRequest request = new StartDeploymentRequest();
            request.deploymentId = this.deploymentId;
            request.startDeploymentDetails = this.startDeploymentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.isLockOverride = this.isLockOverride;
            return request;
        }
    }
}

