/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.goldengate.GoldenGate;
import com.oracle.bmc.goldengate.GoldenGatePaginators;
import com.oracle.bmc.goldengate.GoldenGateWaiters;
import com.oracle.bmc.goldengate.model.Certificate;
import com.oracle.bmc.goldengate.model.CertificateCollection;
import com.oracle.bmc.goldengate.model.Connection;
import com.oracle.bmc.goldengate.model.ConnectionAssignment;
import com.oracle.bmc.goldengate.model.ConnectionAssignmentCollection;
import com.oracle.bmc.goldengate.model.ConnectionCollection;
import com.oracle.bmc.goldengate.model.DatabaseRegistration;
import com.oracle.bmc.goldengate.model.DatabaseRegistrationCollection;
import com.oracle.bmc.goldengate.model.Deployment;
import com.oracle.bmc.goldengate.model.DeploymentBackup;
import com.oracle.bmc.goldengate.model.DeploymentBackupCollection;
import com.oracle.bmc.goldengate.model.DeploymentCollection;
import com.oracle.bmc.goldengate.model.DeploymentEnvironmentCollection;
import com.oracle.bmc.goldengate.model.DeploymentMessageCollection;
import com.oracle.bmc.goldengate.model.DeploymentTypeCollection;
import com.oracle.bmc.goldengate.model.DeploymentUpgrade;
import com.oracle.bmc.goldengate.model.DeploymentUpgradeCollection;
import com.oracle.bmc.goldengate.model.DeploymentVersionCollection;
import com.oracle.bmc.goldengate.model.DeploymentWalletExistsResponseDetails;
import com.oracle.bmc.goldengate.model.DeploymentWalletsOperationCollection;
import com.oracle.bmc.goldengate.model.LibraryUrl;
import com.oracle.bmc.goldengate.model.TestConnectionAssignmentResult;
import com.oracle.bmc.goldengate.model.TrailFileCollection;
import com.oracle.bmc.goldengate.model.TrailSequenceCollection;
import com.oracle.bmc.goldengate.model.WorkRequest;
import com.oracle.bmc.goldengate.model.WorkRequestError;
import com.oracle.bmc.goldengate.model.WorkRequestLogEntry;
import com.oracle.bmc.goldengate.requests.AddConnectionLockRequest;
import com.oracle.bmc.goldengate.requests.AddDeploymentBackupLockRequest;
import com.oracle.bmc.goldengate.requests.AddDeploymentLockRequest;
import com.oracle.bmc.goldengate.requests.CancelDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.CancelDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.CancelSnoozeDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.ChangeConnectionCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDatabaseRegistrationCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDeploymentBackupCompartmentRequest;
import com.oracle.bmc.goldengate.requests.ChangeDeploymentCompartmentRequest;
import com.oracle.bmc.goldengate.requests.CollectDeploymentDiagnosticRequest;
import com.oracle.bmc.goldengate.requests.CopyDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.CreateCertificateRequest;
import com.oracle.bmc.goldengate.requests.CreateConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.CreateConnectionRequest;
import com.oracle.bmc.goldengate.requests.CreateDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.CreateDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.CreateDeploymentRequest;
import com.oracle.bmc.goldengate.requests.DeleteCertificateRequest;
import com.oracle.bmc.goldengate.requests.DeleteConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.DeleteConnectionRequest;
import com.oracle.bmc.goldengate.requests.DeleteDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.DeleteDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.DeleteDeploymentRequest;
import com.oracle.bmc.goldengate.requests.DeploymentWalletExistsRequest;
import com.oracle.bmc.goldengate.requests.ExportDeploymentWalletRequest;
import com.oracle.bmc.goldengate.requests.GenerateLibraryUrlRequest;
import com.oracle.bmc.goldengate.requests.GetCertificateRequest;
import com.oracle.bmc.goldengate.requests.GetConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.GetConnectionRequest;
import com.oracle.bmc.goldengate.requests.GetDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.GetWorkRequestRequest;
import com.oracle.bmc.goldengate.requests.ImportDeploymentWalletRequest;
import com.oracle.bmc.goldengate.requests.ListCertificatesRequest;
import com.oracle.bmc.goldengate.requests.ListConnectionAssignmentsRequest;
import com.oracle.bmc.goldengate.requests.ListConnectionsRequest;
import com.oracle.bmc.goldengate.requests.ListDatabaseRegistrationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentBackupsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentEnvironmentsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentTypesRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentUpgradesRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentVersionsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentWalletsOperationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentsRequest;
import com.oracle.bmc.goldengate.requests.ListMessagesRequest;
import com.oracle.bmc.goldengate.requests.ListTrailFilesRequest;
import com.oracle.bmc.goldengate.requests.ListTrailSequencesRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestsRequest;
import com.oracle.bmc.goldengate.requests.RemoveConnectionLockRequest;
import com.oracle.bmc.goldengate.requests.RemoveDeploymentBackupLockRequest;
import com.oracle.bmc.goldengate.requests.RemoveDeploymentLockRequest;
import com.oracle.bmc.goldengate.requests.RescheduleDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.RestoreDeploymentRequest;
import com.oracle.bmc.goldengate.requests.RollbackDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.SnoozeDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.requests.StartDeploymentRequest;
import com.oracle.bmc.goldengate.requests.StopDeploymentRequest;
import com.oracle.bmc.goldengate.requests.TestConnectionAssignmentRequest;
import com.oracle.bmc.goldengate.requests.UpdateConnectionRequest;
import com.oracle.bmc.goldengate.requests.UpdateDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.UpdateDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.UpdateDeploymentRequest;
import com.oracle.bmc.goldengate.requests.UpgradeDeploymentRequest;
import com.oracle.bmc.goldengate.requests.UpgradeDeploymentUpgradeRequest;
import com.oracle.bmc.goldengate.responses.AddConnectionLockResponse;
import com.oracle.bmc.goldengate.responses.AddDeploymentBackupLockResponse;
import com.oracle.bmc.goldengate.responses.AddDeploymentLockResponse;
import com.oracle.bmc.goldengate.responses.CancelDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.CancelDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.CancelSnoozeDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.ChangeConnectionCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDatabaseRegistrationCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDeploymentBackupCompartmentResponse;
import com.oracle.bmc.goldengate.responses.ChangeDeploymentCompartmentResponse;
import com.oracle.bmc.goldengate.responses.CollectDeploymentDiagnosticResponse;
import com.oracle.bmc.goldengate.responses.CopyDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.CreateCertificateResponse;
import com.oracle.bmc.goldengate.responses.CreateConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.CreateConnectionResponse;
import com.oracle.bmc.goldengate.responses.CreateDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.CreateDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.CreateDeploymentResponse;
import com.oracle.bmc.goldengate.responses.DeleteCertificateResponse;
import com.oracle.bmc.goldengate.responses.DeleteConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.DeleteConnectionResponse;
import com.oracle.bmc.goldengate.responses.DeleteDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.DeleteDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.DeleteDeploymentResponse;
import com.oracle.bmc.goldengate.responses.DeploymentWalletExistsResponse;
import com.oracle.bmc.goldengate.responses.ExportDeploymentWalletResponse;
import com.oracle.bmc.goldengate.responses.GenerateLibraryUrlResponse;
import com.oracle.bmc.goldengate.responses.GetCertificateResponse;
import com.oracle.bmc.goldengate.responses.GetConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.GetConnectionResponse;
import com.oracle.bmc.goldengate.responses.GetDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.GetWorkRequestResponse;
import com.oracle.bmc.goldengate.responses.ImportDeploymentWalletResponse;
import com.oracle.bmc.goldengate.responses.ListCertificatesResponse;
import com.oracle.bmc.goldengate.responses.ListConnectionAssignmentsResponse;
import com.oracle.bmc.goldengate.responses.ListConnectionsResponse;
import com.oracle.bmc.goldengate.responses.ListDatabaseRegistrationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentBackupsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentEnvironmentsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentTypesResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentUpgradesResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentVersionsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentWalletsOperationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentsResponse;
import com.oracle.bmc.goldengate.responses.ListMessagesResponse;
import com.oracle.bmc.goldengate.responses.ListTrailFilesResponse;
import com.oracle.bmc.goldengate.responses.ListTrailSequencesResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestsResponse;
import com.oracle.bmc.goldengate.responses.RemoveConnectionLockResponse;
import com.oracle.bmc.goldengate.responses.RemoveDeploymentBackupLockResponse;
import com.oracle.bmc.goldengate.responses.RemoveDeploymentLockResponse;
import com.oracle.bmc.goldengate.responses.RescheduleDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.RestoreDeploymentResponse;
import com.oracle.bmc.goldengate.responses.RollbackDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.SnoozeDeploymentUpgradeResponse;
import com.oracle.bmc.goldengate.responses.StartDeploymentResponse;
import com.oracle.bmc.goldengate.responses.StopDeploymentResponse;
import com.oracle.bmc.goldengate.responses.TestConnectionAssignmentResponse;
import com.oracle.bmc.goldengate.responses.UpdateConnectionResponse;
import com.oracle.bmc.goldengate.responses.UpdateDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.UpdateDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.UpdateDeploymentResponse;
import com.oracle.bmc.goldengate.responses.UpgradeDeploymentResponse;
import com.oracle.bmc.goldengate.responses.UpgradeDeploymentUpgradeResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldenGateClient
extends BaseSyncClient
implements GoldenGate {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GOLDENGATE").serviceEndpointPrefix("").serviceEndpointTemplate("https://goldengate.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GoldenGateClient.class);
    private final GoldenGateWaiters waiters;
    private final GoldenGatePaginators paginators;

    GoldenGateClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("GoldenGate-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new GoldenGateWaiters(executorService, this);
        this.paginators = new GoldenGatePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddConnectionLockResponse addConnectionLock(AddConnectionLockRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddResourceLockDetails(), "addResourceLockDetails is required");
        return (AddConnectionLockResponse)this.clientCall(request, AddConnectionLockResponse::builder).logger(LOG, "addConnectionLock").serviceDetails("GoldenGate", "AddConnectionLock", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/AddConnectionLock").method(Method.POST).requestBuilder(AddConnectionLockRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(Connection.class, AddConnectionLockResponse.Builder::connection).handleResponseHeaderString("opc-request-id", AddConnectionLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AddConnectionLockResponse.Builder::etag).callSync();
    }

    @Override
    public AddDeploymentBackupLockResponse addDeploymentBackupLock(AddDeploymentBackupLockRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddResourceLockDetails(), "addResourceLockDetails is required");
        return (AddDeploymentBackupLockResponse)this.clientCall(request, AddDeploymentBackupLockResponse::builder).logger(LOG, "addDeploymentBackupLock").serviceDetails("GoldenGate", "AddDeploymentBackupLock", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/AddDeploymentBackupLock").method(Method.POST).requestBuilder(AddDeploymentBackupLockRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(DeploymentBackup.class, AddDeploymentBackupLockResponse.Builder::deploymentBackup).handleResponseHeaderString("opc-request-id", AddDeploymentBackupLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AddDeploymentBackupLockResponse.Builder::etag).callSync();
    }

    @Override
    public AddDeploymentLockResponse addDeploymentLock(AddDeploymentLockRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddResourceLockDetails(), "addResourceLockDetails is required");
        return (AddDeploymentLockResponse)this.clientCall(request, AddDeploymentLockResponse::builder).logger(LOG, "addDeploymentLock").serviceDetails("GoldenGate", "AddDeploymentLock", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/AddDeploymentLock").method(Method.POST).requestBuilder(AddDeploymentLockRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(Deployment.class, AddDeploymentLockResponse.Builder::deployment).handleResponseHeaderString("opc-request-id", AddDeploymentLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AddDeploymentLockResponse.Builder::etag).callSync();
    }

    @Override
    public CancelDeploymentBackupResponse cancelDeploymentBackup(CancelDeploymentBackupRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCancelDeploymentBackupDetails(), "cancelDeploymentBackupDetails is required");
        return (CancelDeploymentBackupResponse)this.clientCall(request, CancelDeploymentBackupResponse::builder).logger(LOG, "cancelDeploymentBackup").serviceDetails("GoldenGate", "CancelDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/CancelDeploymentBackup").method(Method.POST).requestBuilder(CancelDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("cancel").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CancelDeploymentBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CancelDeploymentBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelDeploymentUpgradeResponse cancelDeploymentUpgrade(CancelDeploymentUpgradeRequest request) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCancelDeploymentUpgradeDetails(), "cancelDeploymentUpgradeDetails is required");
        return (CancelDeploymentUpgradeResponse)this.clientCall(request, CancelDeploymentUpgradeResponse::builder).logger(LOG, "cancelDeploymentUpgrade").serviceDetails("GoldenGate", "CancelDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/CancelDeploymentUpgrade").method(Method.POST).requestBuilder(CancelDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(DeploymentUpgrade.class, CancelDeploymentUpgradeResponse.Builder::deploymentUpgrade).handleResponseHeaderString("etag", CancelDeploymentUpgradeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelDeploymentUpgradeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelSnoozeDeploymentUpgradeResponse cancelSnoozeDeploymentUpgrade(CancelSnoozeDeploymentUpgradeRequest request) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCancelSnoozeDeploymentUpgradeDetails(), "cancelSnoozeDeploymentUpgradeDetails is required");
        return (CancelSnoozeDeploymentUpgradeResponse)this.clientCall(request, CancelSnoozeDeploymentUpgradeResponse::builder).logger(LOG, "cancelSnoozeDeploymentUpgrade").serviceDetails("GoldenGate", "CancelSnoozeDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/CancelSnoozeDeploymentUpgrade").method(Method.POST).requestBuilder(CancelSnoozeDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("cancelSnooze").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", CancelSnoozeDeploymentUpgradeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeConnectionCompartmentResponse changeConnectionCompartment(ChangeConnectionCompartmentRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeConnectionCompartmentDetails(), "changeConnectionCompartmentDetails is required");
        return (ChangeConnectionCompartmentResponse)this.clientCall(request, ChangeConnectionCompartmentResponse::builder).logger(LOG, "changeConnectionCompartment").serviceDetails("GoldenGate", "ChangeConnectionCompartment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/ChangeConnectionCompartment").method(Method.POST).requestBuilder(ChangeConnectionCompartmentRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeConnectionCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeConnectionCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDatabaseRegistrationCompartmentResponse changeDatabaseRegistrationCompartment(ChangeDatabaseRegistrationCompartmentRequest request) {
        Validate.notBlank((String)request.getDatabaseRegistrationId(), (String)"databaseRegistrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDatabaseRegistrationCompartmentDetails(), "changeDatabaseRegistrationCompartmentDetails is required");
        return (ChangeDatabaseRegistrationCompartmentResponse)this.clientCall(request, ChangeDatabaseRegistrationCompartmentResponse::builder).logger(LOG, "changeDatabaseRegistrationCompartment").serviceDetails("GoldenGate", "ChangeDatabaseRegistrationCompartment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/ChangeDatabaseRegistrationCompartment").method(Method.POST).requestBuilder(ChangeDatabaseRegistrationCompartmentRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendPathParam(request.getDatabaseRegistrationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDatabaseRegistrationCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDatabaseRegistrationCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", ChangeDatabaseRegistrationCompartmentResponse.Builder::sunset).callSync();
    }

    @Override
    public ChangeDeploymentBackupCompartmentResponse changeDeploymentBackupCompartment(ChangeDeploymentBackupCompartmentRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDeploymentBackupCompartmentDetails(), "changeDeploymentBackupCompartmentDetails is required");
        return (ChangeDeploymentBackupCompartmentResponse)this.clientCall(request, ChangeDeploymentBackupCompartmentResponse::builder).logger(LOG, "changeDeploymentBackupCompartment").serviceDetails("GoldenGate", "ChangeDeploymentBackupCompartment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/ChangeDeploymentBackupCompartment").method(Method.POST).requestBuilder(ChangeDeploymentBackupCompartmentRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeDeploymentBackupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDeploymentCompartmentResponse changeDeploymentCompartment(ChangeDeploymentCompartmentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDeploymentCompartmentDetails(), "changeDeploymentCompartmentDetails is required");
        return (ChangeDeploymentCompartmentResponse)this.clientCall(request, ChangeDeploymentCompartmentResponse::builder).logger(LOG, "changeDeploymentCompartment").serviceDetails("GoldenGate", "ChangeDeploymentCompartment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/ChangeDeploymentCompartment").method(Method.POST).requestBuilder(ChangeDeploymentCompartmentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDeploymentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDeploymentCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CollectDeploymentDiagnosticResponse collectDeploymentDiagnostic(CollectDeploymentDiagnosticRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCollectDeploymentDiagnosticDetails(), "collectDeploymentDiagnosticDetails is required");
        return (CollectDeploymentDiagnosticResponse)this.clientCall(request, CollectDeploymentDiagnosticResponse::builder).logger(LOG, "collectDeploymentDiagnostic").serviceDetails("GoldenGate", "CollectDeploymentDiagnostic", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/CollectDeploymentDiagnostic").method(Method.POST).requestBuilder(CollectDeploymentDiagnosticRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("collectDiagnostics").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CollectDeploymentDiagnosticResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CollectDeploymentDiagnosticResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CopyDeploymentBackupResponse copyDeploymentBackup(CopyDeploymentBackupRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCopyDeploymentBackupDetails(), "copyDeploymentBackupDetails is required");
        return (CopyDeploymentBackupResponse)this.clientCall(request, CopyDeploymentBackupResponse::builder).logger(LOG, "copyDeploymentBackup").serviceDetails("GoldenGate", "CopyDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/CopyDeploymentBackup").method(Method.POST).requestBuilder(CopyDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("copyToBucket").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeploymentBackup.class, CopyDeploymentBackupResponse.Builder::deploymentBackup).handleResponseHeaderString("opc-work-request-id", CopyDeploymentBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CopyDeploymentBackupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CopyDeploymentBackupResponse.Builder::etag).callSync();
    }

    @Override
    public CreateCertificateResponse createCertificate(CreateCertificateRequest request) {
        Objects.requireNonNull(request.getCreateCertificateDetails(), "createCertificateDetails is required");
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return (CreateCertificateResponse)this.clientCall(request, CreateCertificateResponse::builder).logger(LOG, "createCertificate").serviceDetails("GoldenGate", "CreateCertificate", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/CertificateCollection/CreateCertificate").method(Method.POST).requestBuilder(CreateCertificateRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("certificates").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateCertificateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest request) {
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return (CreateConnectionResponse)this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("GoldenGate", "CreateConnection", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/CreateConnection").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20200407").appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("opc-work-request-id", CreateConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).callSync();
    }

    @Override
    public CreateConnectionAssignmentResponse createConnectionAssignment(CreateConnectionAssignmentRequest request) {
        Objects.requireNonNull(request.getCreateConnectionAssignmentDetails(), "createConnectionAssignmentDetails is required");
        return (CreateConnectionAssignmentResponse)this.clientCall(request, CreateConnectionAssignmentResponse::builder).logger(LOG, "createConnectionAssignment").serviceDetails("GoldenGate", "CreateConnectionAssignment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/CreateConnectionAssignment").method(Method.POST).requestBuilder(CreateConnectionAssignmentRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ConnectionAssignment.class, CreateConnectionAssignmentResponse.Builder::connectionAssignment).handleResponseHeaderString("opc-work-request-id", CreateConnectionAssignmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateConnectionAssignmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConnectionAssignmentResponse.Builder::etag).callSync();
    }

    @Override
    public CreateDatabaseRegistrationResponse createDatabaseRegistration(CreateDatabaseRegistrationRequest request) {
        Objects.requireNonNull(request.getCreateDatabaseRegistrationDetails(), "createDatabaseRegistrationDetails is required");
        return (CreateDatabaseRegistrationResponse)this.clientCall(request, CreateDatabaseRegistrationResponse::builder).logger(LOG, "createDatabaseRegistration").serviceDetails("GoldenGate", "CreateDatabaseRegistration", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/CreateDatabaseRegistration").method(Method.POST).requestBuilder(CreateDatabaseRegistrationRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DatabaseRegistration.class, CreateDatabaseRegistrationResponse.Builder::databaseRegistration).handleResponseHeaderString("opc-work-request-id", CreateDatabaseRegistrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDatabaseRegistrationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateDatabaseRegistrationResponse.Builder::etag).handleResponseHeaderString("sunset", CreateDatabaseRegistrationResponse.Builder::sunset).callSync();
    }

    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest request) {
        Objects.requireNonNull(request.getCreateDeploymentDetails(), "createDeploymentDetails is required");
        return (CreateDeploymentResponse)this.clientCall(request, CreateDeploymentResponse::builder).logger(LOG, "createDeployment").serviceDetails("GoldenGate", "CreateDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/CreateDeployment").method(Method.POST).requestBuilder(CreateDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Deployment.class, CreateDeploymentResponse.Builder::deployment).handleResponseHeaderString("opc-work-request-id", CreateDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeploymentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateDeploymentResponse.Builder::etag).callSync();
    }

    @Override
    public CreateDeploymentBackupResponse createDeploymentBackup(CreateDeploymentBackupRequest request) {
        Objects.requireNonNull(request.getCreateDeploymentBackupDetails(), "createDeploymentBackupDetails is required");
        return (CreateDeploymentBackupResponse)this.clientCall(request, CreateDeploymentBackupResponse::builder).logger(LOG, "createDeploymentBackup").serviceDetails("GoldenGate", "CreateDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/CreateDeploymentBackup").method(Method.POST).requestBuilder(CreateDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeploymentBackup.class, CreateDeploymentBackupResponse.Builder::deploymentBackup).handleResponseHeaderString("opc-work-request-id", CreateDeploymentBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeploymentBackupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateDeploymentBackupResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCertificateKey(), (String)"certificateKey must not be blank", (Object[])new Object[0]);
        return (DeleteCertificateResponse)this.clientCall(request, DeleteCertificateResponse::builder).logger(LOG, "deleteCertificate").serviceDetails("GoldenGate", "DeleteCertificate", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Certificate/DeleteCertificate").method(Method.DELETE).requestBuilder(DeleteCertificateRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("certificates").appendPathParam(request.getCertificateKey()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCertificateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return (DeleteConnectionResponse)this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("GoldenGate", "DeleteConnection", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/DeleteConnection").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteConnectionAssignmentResponse deleteConnectionAssignment(DeleteConnectionAssignmentRequest request) {
        Validate.notBlank((String)request.getConnectionAssignmentId(), (String)"connectionAssignmentId must not be blank", (Object[])new Object[0]);
        return (DeleteConnectionAssignmentResponse)this.clientCall(request, DeleteConnectionAssignmentResponse::builder).logger(LOG, "deleteConnectionAssignment").serviceDetails("GoldenGate", "DeleteConnectionAssignment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/DeleteConnectionAssignment").method(Method.DELETE).requestBuilder(DeleteConnectionAssignmentRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendPathParam(request.getConnectionAssignmentId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteConnectionAssignmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteConnectionAssignmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDatabaseRegistrationResponse deleteDatabaseRegistration(DeleteDatabaseRegistrationRequest request) {
        Validate.notBlank((String)request.getDatabaseRegistrationId(), (String)"databaseRegistrationId must not be blank", (Object[])new Object[0]);
        return (DeleteDatabaseRegistrationResponse)this.clientCall(request, DeleteDatabaseRegistrationResponse::builder).logger(LOG, "deleteDatabaseRegistration").serviceDetails("GoldenGate", "DeleteDatabaseRegistration", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/DeleteDatabaseRegistration").method(Method.DELETE).requestBuilder(DeleteDatabaseRegistrationRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendPathParam(request.getDatabaseRegistrationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDatabaseRegistrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDatabaseRegistrationResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", DeleteDatabaseRegistrationResponse.Builder::sunset).callSync();
    }

    @Override
    public DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return (DeleteDeploymentResponse)this.clientCall(request, DeleteDeploymentResponse::builder).logger(LOG, "deleteDeployment").serviceDetails("GoldenGate", "DeleteDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/DeleteDeployment").method(Method.DELETE).requestBuilder(DeleteDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDeploymentBackupResponse deleteDeploymentBackup(DeleteDeploymentBackupRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        return (DeleteDeploymentBackupResponse)this.clientCall(request, DeleteDeploymentBackupResponse::builder).logger(LOG, "deleteDeploymentBackup").serviceDetails("GoldenGate", "DeleteDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/DeleteDeploymentBackup").method(Method.DELETE).requestBuilder(DeleteDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDeploymentBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeploymentBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeploymentWalletExistsResponse deploymentWalletExists(DeploymentWalletExistsRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeploymentWalletExistsDetails(), "deploymentWalletExistsDetails is required");
        return (DeploymentWalletExistsResponse)this.clientCall(request, DeploymentWalletExistsResponse::builder).logger(LOG, "deploymentWalletExists").serviceDetails("GoldenGate", "DeploymentWalletExists", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/DeploymentWalletExists").method(Method.POST).requestBuilder(DeploymentWalletExistsRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("walletExists").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(DeploymentWalletExistsResponseDetails.class, DeploymentWalletExistsResponse.Builder::deploymentWalletExistsResponseDetails).handleResponseHeaderString("opc-request-id", DeploymentWalletExistsResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DeploymentWalletExistsResponse.Builder::etag).callSync();
    }

    @Override
    public ExportDeploymentWalletResponse exportDeploymentWallet(ExportDeploymentWalletRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportDeploymentWalletDetails(), "exportDeploymentWalletDetails is required");
        return (ExportDeploymentWalletResponse)this.clientCall(request, ExportDeploymentWalletResponse::builder).logger(LOG, "exportDeploymentWallet").serviceDetails("GoldenGate", "ExportDeploymentWallet", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/ExportDeploymentWallet").method(Method.POST).requestBuilder(ExportDeploymentWalletRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("exportWallet").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ExportDeploymentWalletResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ExportDeploymentWalletResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GenerateLibraryUrlResponse generateLibraryUrl(GenerateLibraryUrlRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGenerateLibraryUrlDetails(), "generateLibraryUrlDetails is required");
        return (GenerateLibraryUrlResponse)this.clientCall(request, GenerateLibraryUrlResponse::builder).logger(LOG, "generateLibraryUrl").serviceDetails("GoldenGate", "GenerateLibraryUrl", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/GenerateLibraryUrl").method(Method.POST).requestBuilder(GenerateLibraryUrlRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("generateLibraryUrl").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(LibraryUrl.class, GenerateLibraryUrlResponse.Builder::libraryUrl).handleResponseHeaderString("opc-request-id", GenerateLibraryUrlResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GenerateLibraryUrlResponse.Builder::etag).callSync();
    }

    @Override
    public GetCertificateResponse getCertificate(GetCertificateRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCertificateKey(), (String)"certificateKey must not be blank", (Object[])new Object[0]);
        return (GetCertificateResponse)this.clientCall(request, GetCertificateResponse::builder).logger(LOG, "getCertificate").serviceDetails("GoldenGate", "GetCertificate", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Certificate/GetCertificate").method(Method.GET).requestBuilder(GetCertificateRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("certificates").appendPathParam(request.getCertificateKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Certificate.class, GetCertificateResponse.Builder::certificate).handleResponseHeaderString("etag", GetCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return (GetConnectionResponse)this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("GoldenGate", "GetConnection", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/GetConnection").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetConnectionAssignmentResponse getConnectionAssignment(GetConnectionAssignmentRequest request) {
        Validate.notBlank((String)request.getConnectionAssignmentId(), (String)"connectionAssignmentId must not be blank", (Object[])new Object[0]);
        return (GetConnectionAssignmentResponse)this.clientCall(request, GetConnectionAssignmentResponse::builder).logger(LOG, "getConnectionAssignment").serviceDetails("GoldenGate", "GetConnectionAssignment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/GetConnectionAssignment").method(Method.GET).requestBuilder(GetConnectionAssignmentRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendPathParam(request.getConnectionAssignmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ConnectionAssignment.class, GetConnectionAssignmentResponse.Builder::connectionAssignment).handleResponseHeaderString("etag", GetConnectionAssignmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionAssignmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDatabaseRegistrationResponse getDatabaseRegistration(GetDatabaseRegistrationRequest request) {
        Validate.notBlank((String)request.getDatabaseRegistrationId(), (String)"databaseRegistrationId must not be blank", (Object[])new Object[0]);
        return (GetDatabaseRegistrationResponse)this.clientCall(request, GetDatabaseRegistrationResponse::builder).logger(LOG, "getDatabaseRegistration").serviceDetails("GoldenGate", "GetDatabaseRegistration", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/GetDatabaseRegistration").method(Method.GET).requestBuilder(GetDatabaseRegistrationRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendPathParam(request.getDatabaseRegistrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DatabaseRegistration.class, GetDatabaseRegistrationResponse.Builder::databaseRegistration).handleResponseHeaderString("etag", GetDatabaseRegistrationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatabaseRegistrationResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", GetDatabaseRegistrationResponse.Builder::sunset).callSync();
    }

    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return (GetDeploymentResponse)this.clientCall(request, GetDeploymentResponse::builder).logger(LOG, "getDeployment").serviceDetails("GoldenGate", "GetDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/GetDeployment").method(Method.GET).requestBuilder(GetDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Deployment.class, GetDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", GetDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDeploymentBackupResponse getDeploymentBackup(GetDeploymentBackupRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        return (GetDeploymentBackupResponse)this.clientCall(request, GetDeploymentBackupResponse::builder).logger(LOG, "getDeploymentBackup").serviceDetails("GoldenGate", "GetDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/GetDeploymentBackup").method(Method.GET).requestBuilder(GetDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentBackup.class, GetDeploymentBackupResponse.Builder::deploymentBackup).handleResponseHeaderString("etag", GetDeploymentBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDeploymentUpgradeResponse getDeploymentUpgrade(GetDeploymentUpgradeRequest request) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        return (GetDeploymentUpgradeResponse)this.clientCall(request, GetDeploymentUpgradeResponse::builder).logger(LOG, "getDeploymentUpgrade").serviceDetails("GoldenGate", "GetDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/GetDeploymentUpgrade").method(Method.GET).requestBuilder(GetDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentUpgrade.class, GetDeploymentUpgradeResponse.Builder::deploymentUpgrade).handleResponseHeaderString("etag", GetDeploymentUpgradeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentUpgradeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("GoldenGate", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200407").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ImportDeploymentWalletResponse importDeploymentWallet(ImportDeploymentWalletRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportDeploymentWalletDetails(), "importDeploymentWalletDetails is required");
        return (ImportDeploymentWalletResponse)this.clientCall(request, ImportDeploymentWalletResponse::builder).logger(LOG, "importDeploymentWallet").serviceDetails("GoldenGate", "ImportDeploymentWallet", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/ImportDeploymentWallet").method(Method.POST).requestBuilder(ImportDeploymentWalletRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("importWallet").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ImportDeploymentWalletResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportDeploymentWalletResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return (ListCertificatesResponse)this.clientCall(request, ListCertificatesResponse::builder).logger(LOG, "listCertificates").serviceDetails("GoldenGate", "ListCertificates", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/CertificateCollection/ListCertificates").method(Method.GET).requestBuilder(ListCertificatesRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("certificates").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CertificateCollection.class, ListCertificatesResponse.Builder::certificateCollection).handleResponseHeaderString("opc-request-id", ListCertificatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCertificatesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListConnectionAssignmentsResponse listConnectionAssignments(ListConnectionAssignmentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListConnectionAssignmentsResponse)this.clientCall(request, ListConnectionAssignmentsResponse::builder).logger(LOG, "listConnectionAssignments").serviceDetails("GoldenGate", "ListConnectionAssignments", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/ListConnectionAssignments").method(Method.GET).requestBuilder(ListConnectionAssignmentsRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendQueryParam("connectionId", (Object)request.getConnectionId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ConnectionAssignmentCollection.class, ListConnectionAssignmentsResponse.Builder::connectionAssignmentCollection).handleResponseHeaderString("opc-request-id", ListConnectionAssignmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionAssignmentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListConnectionsResponse)this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("GoldenGate", "ListConnections", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/ListConnections").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20200407").appendPathParam("connections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("technologyType", request.getTechnologyType(), CollectionFormatType.Multi).appendListQueryParam("connectionType", request.getConnectionType(), CollectionFormatType.Multi).appendQueryParam("assignedDeploymentId", (Object)request.getAssignedDeploymentId()).appendQueryParam("assignableDeploymentId", (Object)request.getAssignableDeploymentId()).appendEnumQueryParam("assignableDeploymentType", (BmcEnum)request.getAssignableDeploymentType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ConnectionCollection.class, ListConnectionsResponse.Builder::connectionCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDatabaseRegistrationsResponse listDatabaseRegistrations(ListDatabaseRegistrationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDatabaseRegistrationsResponse)this.clientCall(request, ListDatabaseRegistrationsResponse::builder).logger(LOG, "listDatabaseRegistrations").serviceDetails("GoldenGate", "ListDatabaseRegistrations", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/ListDatabaseRegistrations").method(Method.GET).requestBuilder(ListDatabaseRegistrationsRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DatabaseRegistrationCollection.class, ListDatabaseRegistrationsResponse.Builder::databaseRegistrationCollection).handleResponseHeaderString("opc-request-id", ListDatabaseRegistrationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDatabaseRegistrationsResponse.Builder::opcNextPage).handleResponseHeaderString("sunset", ListDatabaseRegistrationsResponse.Builder::sunset).callSync();
    }

    @Override
    public ListDeploymentBackupsResponse listDeploymentBackups(ListDeploymentBackupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDeploymentBackupsResponse)this.clientCall(request, ListDeploymentBackupsResponse::builder).logger(LOG, "listDeploymentBackups").serviceDetails("GoldenGate", "ListDeploymentBackups", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/ListDeploymentBackups").method(Method.GET).requestBuilder(ListDeploymentBackupsRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentBackupCollection.class, ListDeploymentBackupsResponse.Builder::deploymentBackupCollection).handleResponseHeaderString("opc-request-id", ListDeploymentBackupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentBackupsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeploymentEnvironmentsResponse listDeploymentEnvironments(ListDeploymentEnvironmentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDeploymentEnvironmentsResponse)this.clientCall(request, ListDeploymentEnvironmentsResponse::builder).logger(LOG, "listDeploymentEnvironments").serviceDetails("GoldenGate", "ListDeploymentEnvironments", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentEnvironmentCollection/ListDeploymentEnvironments").method(Method.GET).requestBuilder(ListDeploymentEnvironmentsRequest::builder).basePath("/20200407").appendPathParam("deploymentEnvironments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentEnvironmentCollection.class, ListDeploymentEnvironmentsResponse.Builder::deploymentEnvironmentCollection).handleResponseHeaderString("opc-request-id", ListDeploymentEnvironmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentEnvironmentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeploymentTypesResponse listDeploymentTypes(ListDeploymentTypesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDeploymentTypesResponse)this.clientCall(request, ListDeploymentTypesResponse::builder).logger(LOG, "listDeploymentTypes").serviceDetails("GoldenGate", "ListDeploymentTypes", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentTypeCollection/ListDeploymentTypes").method(Method.GET).requestBuilder(ListDeploymentTypesRequest::builder).basePath("/20200407").appendPathParam("deploymentTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("deploymentType", (BmcEnum)request.getDeploymentType()).appendQueryParam("oggVersion", (Object)request.getOggVersion()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentTypeCollection.class, ListDeploymentTypesResponse.Builder::deploymentTypeCollection).handleResponseHeaderString("opc-request-id", ListDeploymentTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentTypesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeploymentUpgradesResponse listDeploymentUpgrades(ListDeploymentUpgradesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDeploymentUpgradesResponse)this.clientCall(request, ListDeploymentUpgradesResponse::builder).logger(LOG, "listDeploymentUpgrades").serviceDetails("GoldenGate", "ListDeploymentUpgrades", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/ListDeploymentUpgrades").method(Method.GET).requestBuilder(ListDeploymentUpgradesRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentUpgradeCollection.class, ListDeploymentUpgradesResponse.Builder::deploymentUpgradeCollection).handleResponseHeaderString("opc-request-id", ListDeploymentUpgradesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentUpgradesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeploymentVersionsResponse listDeploymentVersions(ListDeploymentVersionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDeploymentVersionsResponse)this.clientCall(request, ListDeploymentVersionsResponse::builder).logger(LOG, "listDeploymentVersions").serviceDetails("GoldenGate", "ListDeploymentVersions", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentVersionCollection/ListDeploymentVersions").method(Method.GET).requestBuilder(ListDeploymentVersionsRequest::builder).basePath("/20200407").appendPathParam("deploymentVersions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendEnumQueryParam("deploymentType", (BmcEnum)request.getDeploymentType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentVersionCollection.class, ListDeploymentVersionsResponse.Builder::deploymentVersionCollection).handleResponseHeaderString("opc-request-id", ListDeploymentVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentVersionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeploymentWalletsOperationsResponse listDeploymentWalletsOperations(ListDeploymentWalletsOperationsRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return (ListDeploymentWalletsOperationsResponse)this.clientCall(request, ListDeploymentWalletsOperationsResponse::builder).logger(LOG, "listDeploymentWalletsOperations").serviceDetails("GoldenGate", "ListDeploymentWalletsOperations", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentWalletsOperationSummary/ListDeploymentWalletsOperations").method(Method.GET).requestBuilder(ListDeploymentWalletsOperationsRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("deploymentWalletsOperations").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentWalletsOperationCollection.class, ListDeploymentWalletsOperationsResponse.Builder::deploymentWalletsOperationCollection).handleResponseHeaderString("opc-request-id", ListDeploymentWalletsOperationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentWalletsOperationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeploymentsResponse listDeployments(ListDeploymentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDeploymentsResponse)this.clientCall(request, ListDeploymentsResponse::builder).logger(LOG, "listDeployments").serviceDetails("GoldenGate", "ListDeployments", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/ListDeployments").method(Method.GET).requestBuilder(ListDeploymentsRequest::builder).basePath("/20200407").appendPathParam("deployments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("supportedConnectionType", (BmcEnum)request.getSupportedConnectionType()).appendQueryParam("assignedConnectionId", (Object)request.getAssignedConnectionId()).appendQueryParam("assignableConnectionId", (Object)request.getAssignableConnectionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("lifecycleSubState", (BmcEnum)request.getLifecycleSubState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("fqdn", (Object)request.getFqdn()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentCollection.class, ListDeploymentsResponse.Builder::deploymentCollection).handleResponseHeaderString("opc-request-id", ListDeploymentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListMessagesResponse listMessages(ListMessagesRequest request) {
        Objects.requireNonNull(request.getDeploymentId(), "deploymentId is required");
        return (ListMessagesResponse)this.clientCall(request, ListMessagesResponse::builder).logger(LOG, "listMessages").serviceDetails("GoldenGate", "ListMessages", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/MessageSummary/ListMessages").method(Method.GET).requestBuilder(ListMessagesRequest::builder).basePath("/20200407").appendPathParam("messages").appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentMessageCollection.class, ListMessagesResponse.Builder::deploymentMessageCollection).handleResponseHeaderString("opc-request-id", ListMessagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListTrailFilesResponse listTrailFiles(ListTrailFilesRequest request) {
        Objects.requireNonNull(request.getDeploymentId(), "deploymentId is required");
        return (ListTrailFilesResponse)this.clientCall(request, ListTrailFilesResponse::builder).logger(LOG, "listTrailFiles").serviceDetails("GoldenGate", "ListTrailFiles", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/TrailFileSummary/ListTrailFiles").method(Method.GET).requestBuilder(ListTrailFilesRequest::builder).basePath("/20200407").appendPathParam("trailFiles").appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("trailFileId", (Object)request.getTrailFileId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(TrailFileCollection.class, ListTrailFilesResponse.Builder::trailFileCollection).handleResponseHeaderString("opc-request-id", ListTrailFilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTrailFilesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTrailSequencesResponse listTrailSequences(ListTrailSequencesRequest request) {
        Objects.requireNonNull(request.getDeploymentId(), "deploymentId is required");
        Objects.requireNonNull(request.getTrailFileId(), "trailFileId is required");
        return (ListTrailSequencesResponse)this.clientCall(request, ListTrailSequencesResponse::builder).logger(LOG, "listTrailSequences").serviceDetails("GoldenGate", "ListTrailSequences", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/TrailSequenceSummary/ListTrailSequences").method(Method.GET).requestBuilder(ListTrailSequencesRequest::builder).basePath("/20200407").appendPathParam("trailSequences").appendQueryParam("deploymentId", (Object)request.getDeploymentId()).appendQueryParam("trailFileId", (Object)request.getTrailFileId()).appendQueryParam("trailSequenceId", (Object)request.getTrailSequenceId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(TrailSequenceCollection.class, ListTrailSequencesResponse.Builder::trailSequenceCollection).handleResponseHeaderString("opc-request-id", ListTrailSequencesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTrailSequencesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("GoldenGate", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200407").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("GoldenGate", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200407").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("GoldenGate", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200407").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RemoveConnectionLockResponse removeConnectionLock(RemoveConnectionLockRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveResourceLockDetails(), "removeResourceLockDetails is required");
        return (RemoveConnectionLockResponse)this.clientCall(request, RemoveConnectionLockResponse::builder).logger(LOG, "removeConnectionLock").serviceDetails("GoldenGate", "RemoveConnectionLock", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/RemoveConnectionLock").method(Method.POST).requestBuilder(RemoveConnectionLockRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(Connection.class, RemoveConnectionLockResponse.Builder::connection).handleResponseHeaderString("opc-request-id", RemoveConnectionLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RemoveConnectionLockResponse.Builder::etag).callSync();
    }

    @Override
    public RemoveDeploymentBackupLockResponse removeDeploymentBackupLock(RemoveDeploymentBackupLockRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveResourceLockDetails(), "removeResourceLockDetails is required");
        return (RemoveDeploymentBackupLockResponse)this.clientCall(request, RemoveDeploymentBackupLockResponse::builder).logger(LOG, "removeDeploymentBackupLock").serviceDetails("GoldenGate", "RemoveDeploymentBackupLock", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/RemoveDeploymentBackupLock").method(Method.POST).requestBuilder(RemoveDeploymentBackupLockRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(DeploymentBackup.class, RemoveDeploymentBackupLockResponse.Builder::deploymentBackup).handleResponseHeaderString("opc-request-id", RemoveDeploymentBackupLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RemoveDeploymentBackupLockResponse.Builder::etag).callSync();
    }

    @Override
    public RemoveDeploymentLockResponse removeDeploymentLock(RemoveDeploymentLockRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveResourceLockDetails(), "removeResourceLockDetails is required");
        return (RemoveDeploymentLockResponse)this.clientCall(request, RemoveDeploymentLockResponse::builder).logger(LOG, "removeDeploymentLock").serviceDetails("GoldenGate", "RemoveDeploymentLock", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/RemoveDeploymentLock").method(Method.POST).requestBuilder(RemoveDeploymentLockRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(Deployment.class, RemoveDeploymentLockResponse.Builder::deployment).handleResponseHeaderString("opc-request-id", RemoveDeploymentLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RemoveDeploymentLockResponse.Builder::etag).callSync();
    }

    @Override
    public RescheduleDeploymentUpgradeResponse rescheduleDeploymentUpgrade(RescheduleDeploymentUpgradeRequest request) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRescheduleDeploymentUpgradeDetails(), "rescheduleDeploymentUpgradeDetails is required");
        return (RescheduleDeploymentUpgradeResponse)this.clientCall(request, RescheduleDeploymentUpgradeResponse::builder).logger(LOG, "rescheduleDeploymentUpgrade").serviceDetails("GoldenGate", "RescheduleDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/RescheduleDeploymentUpgrade").method(Method.POST).requestBuilder(RescheduleDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("reschedule").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(DeploymentUpgrade.class, RescheduleDeploymentUpgradeResponse.Builder::deploymentUpgrade).handleResponseHeaderString("etag", RescheduleDeploymentUpgradeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RescheduleDeploymentUpgradeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RestoreDeploymentResponse restoreDeployment(RestoreDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestoreDeploymentDetails(), "restoreDeploymentDetails is required");
        return (RestoreDeploymentResponse)this.clientCall(request, RestoreDeploymentResponse::builder).logger(LOG, "restoreDeployment").serviceDetails("GoldenGate", "RestoreDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/RestoreDeployment").method(Method.POST).requestBuilder(RestoreDeploymentRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendPathParam("actions").appendPathParam("restore").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RestoreDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RestoreDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RollbackDeploymentUpgradeResponse rollbackDeploymentUpgrade(RollbackDeploymentUpgradeRequest request) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRollbackDeploymentUpgradeDetails(), "rollbackDeploymentUpgradeDetails is required");
        return (RollbackDeploymentUpgradeResponse)this.clientCall(request, RollbackDeploymentUpgradeResponse::builder).logger(LOG, "rollbackDeploymentUpgrade").serviceDetails("GoldenGate", "RollbackDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/RollbackDeploymentUpgrade").method(Method.POST).requestBuilder(RollbackDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("rollback").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RollbackDeploymentUpgradeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RollbackDeploymentUpgradeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SnoozeDeploymentUpgradeResponse snoozeDeploymentUpgrade(SnoozeDeploymentUpgradeRequest request) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSnoozeDeploymentUpgradeDetails(), "snoozeDeploymentUpgradeDetails is required");
        return (SnoozeDeploymentUpgradeResponse)this.clientCall(request, SnoozeDeploymentUpgradeResponse::builder).logger(LOG, "snoozeDeploymentUpgrade").serviceDetails("GoldenGate", "SnoozeDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/SnoozeDeploymentUpgrade").method(Method.POST).requestBuilder(SnoozeDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("snooze").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", SnoozeDeploymentUpgradeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StartDeploymentResponse startDeployment(StartDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartDeploymentDetails(), "startDeploymentDetails is required");
        return (StartDeploymentResponse)this.clientCall(request, StartDeploymentResponse::builder).logger(LOG, "startDeployment").serviceDetails("GoldenGate", "StartDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/StartDeployment").method(Method.POST).requestBuilder(StartDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("start").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", StartDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StopDeploymentResponse stopDeployment(StopDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStopDeploymentDetails(), "stopDeploymentDetails is required");
        return (StopDeploymentResponse)this.clientCall(request, StopDeploymentResponse::builder).logger(LOG, "stopDeployment").serviceDetails("GoldenGate", "StopDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/StopDeployment").method(Method.POST).requestBuilder(StopDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("stop").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", StopDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public TestConnectionAssignmentResponse testConnectionAssignment(TestConnectionAssignmentRequest request) {
        Validate.notBlank((String)request.getConnectionAssignmentId(), (String)"connectionAssignmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTestConnectionAssignmentDetails(), "testConnectionAssignmentDetails is required");
        return (TestConnectionAssignmentResponse)this.clientCall(request, TestConnectionAssignmentResponse::builder).logger(LOG, "testConnectionAssignment").serviceDetails("GoldenGate", "TestConnectionAssignment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/ConnectionAssignment/TestConnectionAssignment").method(Method.POST).requestBuilder(TestConnectionAssignmentRequest::builder).basePath("/20200407").appendPathParam("connectionAssignments").appendPathParam(request.getConnectionAssignmentId()).appendPathParam("actions").appendPathParam("test").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(TestConnectionAssignmentResult.class, TestConnectionAssignmentResponse.Builder::testConnectionAssignmentResult).handleResponseHeaderString("opc-request-id", TestConnectionAssignmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", TestConnectionAssignmentResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return (UpdateConnectionResponse)this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("GoldenGate", "UpdateConnection", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Connection/UpdateConnection").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20200407").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDatabaseRegistrationResponse updateDatabaseRegistration(UpdateDatabaseRegistrationRequest request) {
        Validate.notBlank((String)request.getDatabaseRegistrationId(), (String)"databaseRegistrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDatabaseRegistrationDetails(), "updateDatabaseRegistrationDetails is required");
        return (UpdateDatabaseRegistrationResponse)this.clientCall(request, UpdateDatabaseRegistrationResponse::builder).logger(LOG, "updateDatabaseRegistration").serviceDetails("GoldenGate", "UpdateDatabaseRegistration", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DatabaseRegistration/UpdateDatabaseRegistration").method(Method.PUT).requestBuilder(UpdateDatabaseRegistrationRequest::builder).basePath("/20200407").appendPathParam("databaseRegistrations").appendPathParam(request.getDatabaseRegistrationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDatabaseRegistrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDatabaseRegistrationResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", UpdateDatabaseRegistrationResponse.Builder::sunset).callSync();
    }

    @Override
    public UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeploymentDetails(), "updateDeploymentDetails is required");
        return (UpdateDeploymentResponse)this.clientCall(request, UpdateDeploymentResponse::builder).logger(LOG, "updateDeployment").serviceDetails("GoldenGate", "UpdateDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/UpdateDeployment").method(Method.PUT).requestBuilder(UpdateDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDeploymentBackupResponse updateDeploymentBackup(UpdateDeploymentBackupRequest request) {
        Validate.notBlank((String)request.getDeploymentBackupId(), (String)"deploymentBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeploymentBackupDetails(), "updateDeploymentBackupDetails is required");
        return (UpdateDeploymentBackupResponse)this.clientCall(request, UpdateDeploymentBackupResponse::builder).logger(LOG, "updateDeploymentBackup").serviceDetails("GoldenGate", "UpdateDeploymentBackup", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentBackup/UpdateDeploymentBackup").method(Method.PUT).requestBuilder(UpdateDeploymentBackupRequest::builder).basePath("/20200407").appendPathParam("deploymentBackups").appendPathParam(request.getDeploymentBackupId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeploymentBackup.class, UpdateDeploymentBackupResponse.Builder::deploymentBackup).handleResponseHeaderString("etag", UpdateDeploymentBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDeploymentBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpgradeDeploymentResponse upgradeDeployment(UpgradeDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpgradeDeploymentDetails(), "upgradeDeploymentDetails is required");
        return (UpgradeDeploymentResponse)this.clientCall(request, UpgradeDeploymentResponse::builder).logger(LOG, "upgradeDeployment").serviceDetails("GoldenGate", "UpgradeDeployment", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/Deployment/UpgradeDeployment").method(Method.POST).requestBuilder(UpgradeDeploymentRequest::builder).basePath("/20200407").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("upgrade").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpgradeDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpgradeDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpgradeDeploymentUpgradeResponse upgradeDeploymentUpgrade(UpgradeDeploymentUpgradeRequest request) {
        Validate.notBlank((String)request.getDeploymentUpgradeId(), (String)"deploymentUpgradeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpgradeDeploymentUpgradeDetails(), "upgradeDeploymentUpgradeDetails is required");
        return (UpgradeDeploymentUpgradeResponse)this.clientCall(request, UpgradeDeploymentUpgradeResponse::builder).logger(LOG, "upgradeDeploymentUpgrade").serviceDetails("GoldenGate", "UpgradeDeploymentUpgrade", "https://docs.oracle.com/iaas/api/#/en/goldengate/20200407/DeploymentUpgrade/UpgradeDeploymentUpgrade").method(Method.POST).requestBuilder(UpgradeDeploymentUpgradeRequest::builder).basePath("/20200407").appendPathParam("deploymentUpgrades").appendPathParam(request.getDeploymentUpgradeId()).appendPathParam("actions").appendPathParam("upgrade").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpgradeDeploymentUpgradeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpgradeDeploymentUpgradeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GoldenGateWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public GoldenGatePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public GoldenGateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GoldenGateClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GoldenGateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GoldenGateClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GoldenGateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GoldenGateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GoldenGateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GoldenGateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GoldenGateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GoldenGateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GoldenGateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GoldenGateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GoldenGateClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "goldengate";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"goldengate");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public GoldenGateClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GoldenGateClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

