/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.DeploymentCategory;
import com.oracle.bmc.goldengate.model.EnvironmentType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeploymentEnvironmentSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="environmentType")
    private final EnvironmentType environmentType;
    @JsonProperty(value="category")
    private final DeploymentCategory category;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="minCpuCoreCount")
    private final Integer minCpuCoreCount;
    @JsonProperty(value="defaultCpuCoreCount")
    private final Integer defaultCpuCoreCount;
    @JsonProperty(value="maxCpuCoreCount")
    private final Integer maxCpuCoreCount;
    @JsonProperty(value="isAutoScalingEnabledByDefault")
    private final Boolean isAutoScalingEnabledByDefault;
    @JsonProperty(value="networkBandwidthPerOcpuInGbps")
    private final Integer networkBandwidthPerOcpuInGbps;
    @JsonProperty(value="memoryPerOcpuInGBs")
    private final Integer memoryPerOcpuInGBs;
    @JsonProperty(value="storageUsageLimitPerOcpuInGBs")
    private final Integer storageUsageLimitPerOcpuInGBs;

    @Deprecated
    @ConstructorProperties(value={"environmentType", "category", "displayName", "minCpuCoreCount", "defaultCpuCoreCount", "maxCpuCoreCount", "isAutoScalingEnabledByDefault", "networkBandwidthPerOcpuInGbps", "memoryPerOcpuInGBs", "storageUsageLimitPerOcpuInGBs"})
    public DeploymentEnvironmentSummary(EnvironmentType environmentType, DeploymentCategory category, String displayName, Integer minCpuCoreCount, Integer defaultCpuCoreCount, Integer maxCpuCoreCount, Boolean isAutoScalingEnabledByDefault, Integer networkBandwidthPerOcpuInGbps, Integer memoryPerOcpuInGBs, Integer storageUsageLimitPerOcpuInGBs) {
        this.environmentType = environmentType;
        this.category = category;
        this.displayName = displayName;
        this.minCpuCoreCount = minCpuCoreCount;
        this.defaultCpuCoreCount = defaultCpuCoreCount;
        this.maxCpuCoreCount = maxCpuCoreCount;
        this.isAutoScalingEnabledByDefault = isAutoScalingEnabledByDefault;
        this.networkBandwidthPerOcpuInGbps = networkBandwidthPerOcpuInGbps;
        this.memoryPerOcpuInGBs = memoryPerOcpuInGBs;
        this.storageUsageLimitPerOcpuInGBs = storageUsageLimitPerOcpuInGBs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public EnvironmentType getEnvironmentType() {
        return this.environmentType;
    }

    public DeploymentCategory getCategory() {
        return this.category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getMinCpuCoreCount() {
        return this.minCpuCoreCount;
    }

    public Integer getDefaultCpuCoreCount() {
        return this.defaultCpuCoreCount;
    }

    public Integer getMaxCpuCoreCount() {
        return this.maxCpuCoreCount;
    }

    public Boolean getIsAutoScalingEnabledByDefault() {
        return this.isAutoScalingEnabledByDefault;
    }

    public Integer getNetworkBandwidthPerOcpuInGbps() {
        return this.networkBandwidthPerOcpuInGbps;
    }

    public Integer getMemoryPerOcpuInGBs() {
        return this.memoryPerOcpuInGBs;
    }

    public Integer getStorageUsageLimitPerOcpuInGBs() {
        return this.storageUsageLimitPerOcpuInGBs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeploymentEnvironmentSummary(");
        sb.append("super=").append(super.toString());
        sb.append("environmentType=").append(String.valueOf((Object)this.environmentType));
        sb.append(", category=").append(String.valueOf((Object)this.category));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", minCpuCoreCount=").append(String.valueOf(this.minCpuCoreCount));
        sb.append(", defaultCpuCoreCount=").append(String.valueOf(this.defaultCpuCoreCount));
        sb.append(", maxCpuCoreCount=").append(String.valueOf(this.maxCpuCoreCount));
        sb.append(", isAutoScalingEnabledByDefault=").append(String.valueOf(this.isAutoScalingEnabledByDefault));
        sb.append(", networkBandwidthPerOcpuInGbps=").append(String.valueOf(this.networkBandwidthPerOcpuInGbps));
        sb.append(", memoryPerOcpuInGBs=").append(String.valueOf(this.memoryPerOcpuInGBs));
        sb.append(", storageUsageLimitPerOcpuInGBs=").append(String.valueOf(this.storageUsageLimitPerOcpuInGBs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentEnvironmentSummary)) {
            return false;
        }
        DeploymentEnvironmentSummary other = (DeploymentEnvironmentSummary)((Object)o);
        return Objects.equals((Object)this.environmentType, (Object)other.environmentType) && Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.minCpuCoreCount, other.minCpuCoreCount) && Objects.equals(this.defaultCpuCoreCount, other.defaultCpuCoreCount) && Objects.equals(this.maxCpuCoreCount, other.maxCpuCoreCount) && Objects.equals(this.isAutoScalingEnabledByDefault, other.isAutoScalingEnabledByDefault) && Objects.equals(this.networkBandwidthPerOcpuInGbps, other.networkBandwidthPerOcpuInGbps) && Objects.equals(this.memoryPerOcpuInGBs, other.memoryPerOcpuInGBs) && Objects.equals(this.storageUsageLimitPerOcpuInGBs, other.storageUsageLimitPerOcpuInGBs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.environmentType == null ? 43 : this.environmentType.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.minCpuCoreCount == null ? 43 : this.minCpuCoreCount.hashCode());
        result = result * 59 + (this.defaultCpuCoreCount == null ? 43 : this.defaultCpuCoreCount.hashCode());
        result = result * 59 + (this.maxCpuCoreCount == null ? 43 : this.maxCpuCoreCount.hashCode());
        result = result * 59 + (this.isAutoScalingEnabledByDefault == null ? 43 : this.isAutoScalingEnabledByDefault.hashCode());
        result = result * 59 + (this.networkBandwidthPerOcpuInGbps == null ? 43 : this.networkBandwidthPerOcpuInGbps.hashCode());
        result = result * 59 + (this.memoryPerOcpuInGBs == null ? 43 : this.memoryPerOcpuInGBs.hashCode());
        result = result * 59 + (this.storageUsageLimitPerOcpuInGBs == null ? 43 : this.storageUsageLimitPerOcpuInGBs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="environmentType")
        private EnvironmentType environmentType;
        @JsonProperty(value="category")
        private DeploymentCategory category;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="minCpuCoreCount")
        private Integer minCpuCoreCount;
        @JsonProperty(value="defaultCpuCoreCount")
        private Integer defaultCpuCoreCount;
        @JsonProperty(value="maxCpuCoreCount")
        private Integer maxCpuCoreCount;
        @JsonProperty(value="isAutoScalingEnabledByDefault")
        private Boolean isAutoScalingEnabledByDefault;
        @JsonProperty(value="networkBandwidthPerOcpuInGbps")
        private Integer networkBandwidthPerOcpuInGbps;
        @JsonProperty(value="memoryPerOcpuInGBs")
        private Integer memoryPerOcpuInGBs;
        @JsonProperty(value="storageUsageLimitPerOcpuInGBs")
        private Integer storageUsageLimitPerOcpuInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder environmentType(EnvironmentType environmentType) {
            this.environmentType = environmentType;
            this.__explicitlySet__.add("environmentType");
            return this;
        }

        public Builder category(DeploymentCategory category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder minCpuCoreCount(Integer minCpuCoreCount) {
            this.minCpuCoreCount = minCpuCoreCount;
            this.__explicitlySet__.add("minCpuCoreCount");
            return this;
        }

        public Builder defaultCpuCoreCount(Integer defaultCpuCoreCount) {
            this.defaultCpuCoreCount = defaultCpuCoreCount;
            this.__explicitlySet__.add("defaultCpuCoreCount");
            return this;
        }

        public Builder maxCpuCoreCount(Integer maxCpuCoreCount) {
            this.maxCpuCoreCount = maxCpuCoreCount;
            this.__explicitlySet__.add("maxCpuCoreCount");
            return this;
        }

        public Builder isAutoScalingEnabledByDefault(Boolean isAutoScalingEnabledByDefault) {
            this.isAutoScalingEnabledByDefault = isAutoScalingEnabledByDefault;
            this.__explicitlySet__.add("isAutoScalingEnabledByDefault");
            return this;
        }

        public Builder networkBandwidthPerOcpuInGbps(Integer networkBandwidthPerOcpuInGbps) {
            this.networkBandwidthPerOcpuInGbps = networkBandwidthPerOcpuInGbps;
            this.__explicitlySet__.add("networkBandwidthPerOcpuInGbps");
            return this;
        }

        public Builder memoryPerOcpuInGBs(Integer memoryPerOcpuInGBs) {
            this.memoryPerOcpuInGBs = memoryPerOcpuInGBs;
            this.__explicitlySet__.add("memoryPerOcpuInGBs");
            return this;
        }

        public Builder storageUsageLimitPerOcpuInGBs(Integer storageUsageLimitPerOcpuInGBs) {
            this.storageUsageLimitPerOcpuInGBs = storageUsageLimitPerOcpuInGBs;
            this.__explicitlySet__.add("storageUsageLimitPerOcpuInGBs");
            return this;
        }

        public DeploymentEnvironmentSummary build() {
            DeploymentEnvironmentSummary model = new DeploymentEnvironmentSummary(this.environmentType, this.category, this.displayName, this.minCpuCoreCount, this.defaultCpuCoreCount, this.maxCpuCoreCount, this.isAutoScalingEnabledByDefault, this.networkBandwidthPerOcpuInGbps, this.memoryPerOcpuInGBs, this.storageUsageLimitPerOcpuInGBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeploymentEnvironmentSummary model) {
            if (model.wasPropertyExplicitlySet("environmentType")) {
                this.environmentType(model.getEnvironmentType());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("minCpuCoreCount")) {
                this.minCpuCoreCount(model.getMinCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("defaultCpuCoreCount")) {
                this.defaultCpuCoreCount(model.getDefaultCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("maxCpuCoreCount")) {
                this.maxCpuCoreCount(model.getMaxCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("isAutoScalingEnabledByDefault")) {
                this.isAutoScalingEnabledByDefault(model.getIsAutoScalingEnabledByDefault());
            }
            if (model.wasPropertyExplicitlySet("networkBandwidthPerOcpuInGbps")) {
                this.networkBandwidthPerOcpuInGbps(model.getNetworkBandwidthPerOcpuInGbps());
            }
            if (model.wasPropertyExplicitlySet("memoryPerOcpuInGBs")) {
                this.memoryPerOcpuInGBs(model.getMemoryPerOcpuInGBs());
            }
            if (model.wasPropertyExplicitlySet("storageUsageLimitPerOcpuInGBs")) {
                this.storageUsageLimitPerOcpuInGBs(model.getStorageUsageLimitPerOcpuInGBs());
            }
            return this;
        }
    }
}

