/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.goldengate.model.DeploymentType;
import com.oracle.bmc.goldengate.model.ReleaseType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeploymentVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="oggVersion")
    private final String oggVersion;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="timeReleased")
    private final Date timeReleased;
    @JsonProperty(value="releaseType")
    private final ReleaseType releaseType;
    @JsonProperty(value="isSecurityFix")
    private final Boolean isSecurityFix;
    @JsonProperty(value="timeSupportedUntil")
    private final Date timeSupportedUntil;

    @Deprecated
    @ConstructorProperties(value={"oggVersion", "deploymentType", "timeReleased", "releaseType", "isSecurityFix", "timeSupportedUntil"})
    public DeploymentVersionSummary(String oggVersion, DeploymentType deploymentType, Date timeReleased, ReleaseType releaseType, Boolean isSecurityFix, Date timeSupportedUntil) {
        this.oggVersion = oggVersion;
        this.deploymentType = deploymentType;
        this.timeReleased = timeReleased;
        this.releaseType = releaseType;
        this.isSecurityFix = isSecurityFix;
        this.timeSupportedUntil = timeSupportedUntil;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOggVersion() {
        return this.oggVersion;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public Date getTimeReleased() {
        return this.timeReleased;
    }

    public ReleaseType getReleaseType() {
        return this.releaseType;
    }

    public Boolean getIsSecurityFix() {
        return this.isSecurityFix;
    }

    public Date getTimeSupportedUntil() {
        return this.timeSupportedUntil;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeploymentVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("oggVersion=").append(String.valueOf(this.oggVersion));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", timeReleased=").append(String.valueOf(this.timeReleased));
        sb.append(", releaseType=").append(String.valueOf((Object)this.releaseType));
        sb.append(", isSecurityFix=").append(String.valueOf(this.isSecurityFix));
        sb.append(", timeSupportedUntil=").append(String.valueOf(this.timeSupportedUntil));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentVersionSummary)) {
            return false;
        }
        DeploymentVersionSummary other = (DeploymentVersionSummary)((Object)o);
        return Objects.equals(this.oggVersion, other.oggVersion) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.timeReleased, other.timeReleased) && Objects.equals((Object)this.releaseType, (Object)other.releaseType) && Objects.equals(this.isSecurityFix, other.isSecurityFix) && Objects.equals(this.timeSupportedUntil, other.timeSupportedUntil) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.oggVersion == null ? 43 : this.oggVersion.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.timeReleased == null ? 43 : this.timeReleased.hashCode());
        result = result * 59 + (this.releaseType == null ? 43 : this.releaseType.hashCode());
        result = result * 59 + (this.isSecurityFix == null ? 43 : this.isSecurityFix.hashCode());
        result = result * 59 + (this.timeSupportedUntil == null ? 43 : this.timeSupportedUntil.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="oggVersion")
        private String oggVersion;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="timeReleased")
        private Date timeReleased;
        @JsonProperty(value="releaseType")
        private ReleaseType releaseType;
        @JsonProperty(value="isSecurityFix")
        private Boolean isSecurityFix;
        @JsonProperty(value="timeSupportedUntil")
        private Date timeSupportedUntil;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder oggVersion(String oggVersion) {
            this.oggVersion = oggVersion;
            this.__explicitlySet__.add("oggVersion");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder timeReleased(Date timeReleased) {
            this.timeReleased = timeReleased;
            this.__explicitlySet__.add("timeReleased");
            return this;
        }

        public Builder releaseType(ReleaseType releaseType) {
            this.releaseType = releaseType;
            this.__explicitlySet__.add("releaseType");
            return this;
        }

        public Builder isSecurityFix(Boolean isSecurityFix) {
            this.isSecurityFix = isSecurityFix;
            this.__explicitlySet__.add("isSecurityFix");
            return this;
        }

        public Builder timeSupportedUntil(Date timeSupportedUntil) {
            this.timeSupportedUntil = timeSupportedUntil;
            this.__explicitlySet__.add("timeSupportedUntil");
            return this;
        }

        public DeploymentVersionSummary build() {
            DeploymentVersionSummary model = new DeploymentVersionSummary(this.oggVersion, this.deploymentType, this.timeReleased, this.releaseType, this.isSecurityFix, this.timeSupportedUntil);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeploymentVersionSummary model) {
            if (model.wasPropertyExplicitlySet("oggVersion")) {
                this.oggVersion(model.getOggVersion());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("timeReleased")) {
                this.timeReleased(model.getTimeReleased());
            }
            if (model.wasPropertyExplicitlySet("releaseType")) {
                this.releaseType(model.getReleaseType());
            }
            if (model.wasPropertyExplicitlySet("isSecurityFix")) {
                this.isSecurityFix(model.getIsSecurityFix());
            }
            if (model.wasPropertyExplicitlySet("timeSupportedUntil")) {
                this.timeSupportedUntil(model.getTimeSupportedUntil());
            }
            return this;
        }
    }
}

