/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum TechnologyType implements BmcEnum
{
    Goldengate("GOLDENGATE"),
    Generic("GENERIC"),
    OciAutonomousDatabase("OCI_AUTONOMOUS_DATABASE"),
    OciAutonomousJsonDatabase("OCI_AUTONOMOUS_JSON_DATABASE"),
    OciCacheWithRedis("OCI_CACHE_WITH_REDIS"),
    OciMysql("OCI_MYSQL"),
    OciObjectStorage("OCI_OBJECT_STORAGE"),
    OciPostgresql("OCI_POSTGRESQL"),
    OciStreaming("OCI_STREAMING"),
    OracleDatabase("ORACLE_DATABASE"),
    OracleExadata("ORACLE_EXADATA"),
    OracleExadataDatabaseAtAzure("ORACLE_EXADATA_DATABASE_AT_AZURE"),
    OracleNosql("ORACLE_NOSQL"),
    OracleWeblogicJms("ORACLE_WEBLOGIC_JMS"),
    AmazonRdsOracle("AMAZON_RDS_ORACLE"),
    AmazonRdsSqlserver("AMAZON_RDS_SQLSERVER"),
    AmazonS3("AMAZON_S3"),
    AmazonAuroraMysql("AMAZON_AURORA_MYSQL"),
    AmazonAuroraPostgresql("AMAZON_AURORA_POSTGRESQL"),
    AmazonKinesis("AMAZON_KINESIS"),
    AmazonRedshift("AMAZON_REDSHIFT"),
    AmazonRdsMariadb("AMAZON_RDS_MARIADB"),
    AmazonRdsMysql("AMAZON_RDS_MYSQL"),
    AmazonRdsPostgresql("AMAZON_RDS_POSTGRESQL"),
    ApacheKafka("APACHE_KAFKA"),
    AzureCosmosDbForMongodb("AZURE_COSMOS_DB_FOR_MONGODB"),
    AzureCosmosDbForPostgresql("AZURE_COSMOS_DB_FOR_POSTGRESQL"),
    AzureDataLakeStorage("AZURE_DATA_LAKE_STORAGE"),
    AzureEventHubs("AZURE_EVENT_HUBS"),
    AzureMysql("AZURE_MYSQL"),
    AzurePostgresql("AZURE_POSTGRESQL"),
    AzureSqlserverManagedInstance("AZURE_SQLSERVER_MANAGED_INSTANCE"),
    AzureSqlserverNonManagedInstance("AZURE_SQLSERVER_NON_MANAGED_INSTANCE"),
    AzureSynapseAnalytics("AZURE_SYNAPSE_ANALYTICS"),
    ConfluentKafka("CONFLUENT_KAFKA"),
    ConfluentSchemaRegistry("CONFLUENT_SCHEMA_REGISTRY"),
    Db2Zos("DB2_ZOS"),
    Elasticsearch("ELASTICSEARCH"),
    GoogleBigquery("GOOGLE_BIGQUERY"),
    GoogleCloudStorage("GOOGLE_CLOUD_STORAGE"),
    GoogleCloudSqlMysql("GOOGLE_CLOUD_SQL_MYSQL"),
    GoogleCloudSqlPostgresql("GOOGLE_CLOUD_SQL_POSTGRESQL"),
    GoogleCloudSqlSqlserver("GOOGLE_CLOUD_SQL_SQLSERVER"),
    Hdfs("HDFS"),
    Mariadb("MARIADB"),
    MicrosoftSqlserver("MICROSOFT_SQLSERVER"),
    Mongodb("MONGODB"),
    MysqlServer("MYSQL_SERVER"),
    MysqlHeatwaveOnAzure("MYSQL_HEATWAVE_ON_AZURE"),
    MysqlHeatwaveOnAws("MYSQL_HEATWAVE_ON_AWS"),
    PostgresqlServer("POSTGRESQL_SERVER"),
    Redis("REDIS"),
    Singlestoredb("SINGLESTOREDB"),
    SinglestoredbCloud("SINGLESTOREDB_CLOUD"),
    Snowflake("SNOWFLAKE");

    private final String value;
    private static Map<String, TechnologyType> map;

    private TechnologyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static TechnologyType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid TechnologyType: " + key);
    }

    static {
        map = new HashMap<String, TechnologyType>();
        for (TechnologyType v : TechnologyType.values()) {
            map.put(v.getValue(), v);
        }
    }
}

