/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCertificateRequest
extends BmcRequest<Void> {
    private String deploymentId;
    private String certificateKey;
    private String opcRequestId;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getCertificateKey() {
        return this.certificateKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().deploymentId(this.deploymentId).certificateKey(this.certificateKey).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",deploymentId=").append(String.valueOf(this.deploymentId));
        sb.append(",certificateKey=").append(String.valueOf(this.certificateKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCertificateRequest)) {
            return false;
        }
        GetCertificateRequest other = (GetCertificateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals(this.certificateKey, other.certificateKey) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deploymentId == null ? 43 : this.deploymentId.hashCode());
        result = result * 59 + (this.certificateKey == null ? 43 : this.certificateKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCertificateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String deploymentId = null;
        private String certificateKey = null;
        private String opcRequestId = null;

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder certificateKey(String certificateKey) {
            this.certificateKey = certificateKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCertificateRequest o) {
            this.deploymentId(o.getDeploymentId());
            this.certificateKey(o.getCertificateKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCertificateRequest build() {
            GetCertificateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCertificateRequest buildWithoutInvocationCallback() {
            GetCertificateRequest request = new GetCertificateRequest();
            request.deploymentId = this.deploymentId;
            request.certificateKey = this.certificateKey;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

