/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.goldengate.model.UpdateDeploymentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDeploymentRequest
extends BmcRequest<UpdateDeploymentDetails> {
    private String deploymentId;
    private UpdateDeploymentDetails updateDeploymentDetails;
    private String ifMatch;
    private String opcRequestId;
    private Boolean isLockOverride;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public UpdateDeploymentDetails getUpdateDeploymentDetails() {
        return this.updateDeploymentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsLockOverride() {
        return this.isLockOverride;
    }

    @InternalSdk
    public UpdateDeploymentDetails getBody$() {
        return this.updateDeploymentDetails;
    }

    public Builder toBuilder() {
        return new Builder().deploymentId(this.deploymentId).updateDeploymentDetails(this.updateDeploymentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).isLockOverride(this.isLockOverride);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",deploymentId=").append(String.valueOf(this.deploymentId));
        sb.append(",updateDeploymentDetails=").append(String.valueOf((Object)this.updateDeploymentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isLockOverride=").append(String.valueOf(this.isLockOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDeploymentRequest)) {
            return false;
        }
        UpdateDeploymentRequest other = (UpdateDeploymentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals((Object)this.updateDeploymentDetails, (Object)other.updateDeploymentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isLockOverride, other.isLockOverride);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deploymentId == null ? 43 : this.deploymentId.hashCode());
        result = result * 59 + (this.updateDeploymentDetails == null ? 43 : this.updateDeploymentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isLockOverride == null ? 43 : this.isLockOverride.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDeploymentRequest, UpdateDeploymentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String deploymentId = null;
        private UpdateDeploymentDetails updateDeploymentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private Boolean isLockOverride = null;

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder updateDeploymentDetails(UpdateDeploymentDetails updateDeploymentDetails) {
            this.updateDeploymentDetails = updateDeploymentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isLockOverride(Boolean isLockOverride) {
            this.isLockOverride = isLockOverride;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDeploymentRequest o) {
            this.deploymentId(o.getDeploymentId());
            this.updateDeploymentDetails(o.getUpdateDeploymentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.isLockOverride(o.getIsLockOverride());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDeploymentRequest build() {
            UpdateDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDeploymentDetails body) {
            this.updateDeploymentDetails(body);
            return this;
        }

        public UpdateDeploymentRequest buildWithoutInvocationCallback() {
            UpdateDeploymentRequest request = new UpdateDeploymentRequest();
            request.deploymentId = this.deploymentId;
            request.updateDeploymentDetails = this.updateDeploymentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.isLockOverride = this.isLockOverride;
            return request;
        }
    }
}

