/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.governancerulescontrolplane;

import com.oracle.bmc.governancerulescontrolplane.GovernanceRule;
import com.oracle.bmc.governancerulescontrolplane.model.EnforcedGovernanceRuleSummary;
import com.oracle.bmc.governancerulescontrolplane.model.GovernanceRuleSummary;
import com.oracle.bmc.governancerulescontrolplane.model.InclusionCriterionSummary;
import com.oracle.bmc.governancerulescontrolplane.model.TenancyAttachmentSummary;
import com.oracle.bmc.governancerulescontrolplane.requests.ListEnforcedGovernanceRulesRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListGovernanceRulesRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListInclusionCriteriaRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListTenancyAttachmentsRequest;
import com.oracle.bmc.governancerulescontrolplane.responses.ListEnforcedGovernanceRulesResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListGovernanceRulesResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListInclusionCriteriaResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListTenancyAttachmentsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class GovernanceRulePaginators {
    private final GovernanceRule client;

    public GovernanceRulePaginators(GovernanceRule client) {
        this.client = client;
    }

    public Iterable<ListEnforcedGovernanceRulesResponse> listEnforcedGovernanceRulesResponseIterator(final ListEnforcedGovernanceRulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEnforcedGovernanceRulesRequest.Builder>(){

            @Override
            public ListEnforcedGovernanceRulesRequest.Builder get() {
                return ListEnforcedGovernanceRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEnforcedGovernanceRulesResponse, String>(){

            @Override
            public String apply(ListEnforcedGovernanceRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEnforcedGovernanceRulesRequest.Builder>, ListEnforcedGovernanceRulesRequest>(){

            @Override
            public ListEnforcedGovernanceRulesRequest apply(RequestBuilderAndToken<ListEnforcedGovernanceRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEnforcedGovernanceRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEnforcedGovernanceRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEnforcedGovernanceRulesRequest, ListEnforcedGovernanceRulesResponse>(){

            @Override
            public ListEnforcedGovernanceRulesResponse apply(ListEnforcedGovernanceRulesRequest request) {
                return GovernanceRulePaginators.this.client.listEnforcedGovernanceRules(request);
            }
        });
    }

    public Iterable<EnforcedGovernanceRuleSummary> listEnforcedGovernanceRulesRecordIterator(final ListEnforcedGovernanceRulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEnforcedGovernanceRulesRequest.Builder>(){

            @Override
            public ListEnforcedGovernanceRulesRequest.Builder get() {
                return ListEnforcedGovernanceRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEnforcedGovernanceRulesResponse, String>(){

            @Override
            public String apply(ListEnforcedGovernanceRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEnforcedGovernanceRulesRequest.Builder>, ListEnforcedGovernanceRulesRequest>(){

            @Override
            public ListEnforcedGovernanceRulesRequest apply(RequestBuilderAndToken<ListEnforcedGovernanceRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEnforcedGovernanceRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEnforcedGovernanceRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEnforcedGovernanceRulesRequest, ListEnforcedGovernanceRulesResponse>(){

            @Override
            public ListEnforcedGovernanceRulesResponse apply(ListEnforcedGovernanceRulesRequest request) {
                return GovernanceRulePaginators.this.client.listEnforcedGovernanceRules(request);
            }
        }, (Function)new Function<ListEnforcedGovernanceRulesResponse, List<EnforcedGovernanceRuleSummary>>(){

            @Override
            public List<EnforcedGovernanceRuleSummary> apply(ListEnforcedGovernanceRulesResponse response) {
                return response.getEnforcedGovernanceRuleCollection().getItems();
            }
        });
    }

    public Iterable<ListGovernanceRulesResponse> listGovernanceRulesResponseIterator(final ListGovernanceRulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListGovernanceRulesRequest.Builder>(){

            @Override
            public ListGovernanceRulesRequest.Builder get() {
                return ListGovernanceRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGovernanceRulesResponse, String>(){

            @Override
            public String apply(ListGovernanceRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGovernanceRulesRequest.Builder>, ListGovernanceRulesRequest>(){

            @Override
            public ListGovernanceRulesRequest apply(RequestBuilderAndToken<ListGovernanceRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListGovernanceRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGovernanceRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListGovernanceRulesRequest, ListGovernanceRulesResponse>(){

            @Override
            public ListGovernanceRulesResponse apply(ListGovernanceRulesRequest request) {
                return GovernanceRulePaginators.this.client.listGovernanceRules(request);
            }
        });
    }

    public Iterable<GovernanceRuleSummary> listGovernanceRulesRecordIterator(final ListGovernanceRulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListGovernanceRulesRequest.Builder>(){

            @Override
            public ListGovernanceRulesRequest.Builder get() {
                return ListGovernanceRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGovernanceRulesResponse, String>(){

            @Override
            public String apply(ListGovernanceRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGovernanceRulesRequest.Builder>, ListGovernanceRulesRequest>(){

            @Override
            public ListGovernanceRulesRequest apply(RequestBuilderAndToken<ListGovernanceRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListGovernanceRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGovernanceRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListGovernanceRulesRequest, ListGovernanceRulesResponse>(){

            @Override
            public ListGovernanceRulesResponse apply(ListGovernanceRulesRequest request) {
                return GovernanceRulePaginators.this.client.listGovernanceRules(request);
            }
        }, (Function)new Function<ListGovernanceRulesResponse, List<GovernanceRuleSummary>>(){

            @Override
            public List<GovernanceRuleSummary> apply(ListGovernanceRulesResponse response) {
                return response.getGovernanceRuleCollection().getItems();
            }
        });
    }

    public Iterable<ListInclusionCriteriaResponse> listInclusionCriteriaResponseIterator(final ListInclusionCriteriaRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListInclusionCriteriaRequest.Builder>(){

            @Override
            public ListInclusionCriteriaRequest.Builder get() {
                return ListInclusionCriteriaRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInclusionCriteriaResponse, String>(){

            @Override
            public String apply(ListInclusionCriteriaResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInclusionCriteriaRequest.Builder>, ListInclusionCriteriaRequest>(){

            @Override
            public ListInclusionCriteriaRequest apply(RequestBuilderAndToken<ListInclusionCriteriaRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInclusionCriteriaRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInclusionCriteriaRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInclusionCriteriaRequest, ListInclusionCriteriaResponse>(){

            @Override
            public ListInclusionCriteriaResponse apply(ListInclusionCriteriaRequest request) {
                return GovernanceRulePaginators.this.client.listInclusionCriteria(request);
            }
        });
    }

    public Iterable<InclusionCriterionSummary> listInclusionCriteriaRecordIterator(final ListInclusionCriteriaRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListInclusionCriteriaRequest.Builder>(){

            @Override
            public ListInclusionCriteriaRequest.Builder get() {
                return ListInclusionCriteriaRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInclusionCriteriaResponse, String>(){

            @Override
            public String apply(ListInclusionCriteriaResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInclusionCriteriaRequest.Builder>, ListInclusionCriteriaRequest>(){

            @Override
            public ListInclusionCriteriaRequest apply(RequestBuilderAndToken<ListInclusionCriteriaRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInclusionCriteriaRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInclusionCriteriaRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInclusionCriteriaRequest, ListInclusionCriteriaResponse>(){

            @Override
            public ListInclusionCriteriaResponse apply(ListInclusionCriteriaRequest request) {
                return GovernanceRulePaginators.this.client.listInclusionCriteria(request);
            }
        }, (Function)new Function<ListInclusionCriteriaResponse, List<InclusionCriterionSummary>>(){

            @Override
            public List<InclusionCriterionSummary> apply(ListInclusionCriteriaResponse response) {
                return response.getInclusionCriterionCollection().getItems();
            }
        });
    }

    public Iterable<ListTenancyAttachmentsResponse> listTenancyAttachmentsResponseIterator(final ListTenancyAttachmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTenancyAttachmentsRequest.Builder>(){

            @Override
            public ListTenancyAttachmentsRequest.Builder get() {
                return ListTenancyAttachmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTenancyAttachmentsResponse, String>(){

            @Override
            public String apply(ListTenancyAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTenancyAttachmentsRequest.Builder>, ListTenancyAttachmentsRequest>(){

            @Override
            public ListTenancyAttachmentsRequest apply(RequestBuilderAndToken<ListTenancyAttachmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTenancyAttachmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTenancyAttachmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTenancyAttachmentsRequest, ListTenancyAttachmentsResponse>(){

            @Override
            public ListTenancyAttachmentsResponse apply(ListTenancyAttachmentsRequest request) {
                return GovernanceRulePaginators.this.client.listTenancyAttachments(request);
            }
        });
    }

    public Iterable<TenancyAttachmentSummary> listTenancyAttachmentsRecordIterator(final ListTenancyAttachmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTenancyAttachmentsRequest.Builder>(){

            @Override
            public ListTenancyAttachmentsRequest.Builder get() {
                return ListTenancyAttachmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTenancyAttachmentsResponse, String>(){

            @Override
            public String apply(ListTenancyAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTenancyAttachmentsRequest.Builder>, ListTenancyAttachmentsRequest>(){

            @Override
            public ListTenancyAttachmentsRequest apply(RequestBuilderAndToken<ListTenancyAttachmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTenancyAttachmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTenancyAttachmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTenancyAttachmentsRequest, ListTenancyAttachmentsResponse>(){

            @Override
            public ListTenancyAttachmentsResponse apply(ListTenancyAttachmentsRequest request) {
                return GovernanceRulePaginators.this.client.listTenancyAttachments(request);
            }
        }, (Function)new Function<ListTenancyAttachmentsResponse, List<TenancyAttachmentSummary>>(){

            @Override
            public List<TenancyAttachmentSummary> apply(ListTenancyAttachmentsResponse response) {
                return response.getTenancyAttachmentCollection().getItems();
            }
        });
    }
}

