/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.healthchecks.HealthChecks;
import com.oracle.bmc.healthchecks.model.HealthChecksVantagePointSummary;
import com.oracle.bmc.healthchecks.model.HttpMonitorSummary;
import com.oracle.bmc.healthchecks.model.HttpProbeResultSummary;
import com.oracle.bmc.healthchecks.model.PingMonitorSummary;
import com.oracle.bmc.healthchecks.model.PingProbeResultSummary;
import com.oracle.bmc.healthchecks.requests.ListHealthChecksVantagePointsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingProbeResultsRequest;
import com.oracle.bmc.healthchecks.responses.ListHealthChecksVantagePointsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingProbeResultsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class HealthChecksPaginators {
    private final HealthChecks client;

    public Iterable<ListHealthChecksVantagePointsResponse> listHealthChecksVantagePointsResponseIterator(final ListHealthChecksVantagePointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHealthChecksVantagePointsRequest.Builder>(){

            public ListHealthChecksVantagePointsRequest.Builder get() {
                return ListHealthChecksVantagePointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHealthChecksVantagePointsResponse, String>(){

            public String apply(ListHealthChecksVantagePointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHealthChecksVantagePointsRequest.Builder>, ListHealthChecksVantagePointsRequest>(){

            public ListHealthChecksVantagePointsRequest apply(RequestBuilderAndToken<ListHealthChecksVantagePointsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHealthChecksVantagePointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHealthChecksVantagePointsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse>(){

            public ListHealthChecksVantagePointsResponse apply(ListHealthChecksVantagePointsRequest request) {
                return HealthChecksPaginators.this.client.listHealthChecksVantagePoints(request);
            }
        });
    }

    public Iterable<HealthChecksVantagePointSummary> listHealthChecksVantagePointsRecordIterator(final ListHealthChecksVantagePointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHealthChecksVantagePointsRequest.Builder>(){

            public ListHealthChecksVantagePointsRequest.Builder get() {
                return ListHealthChecksVantagePointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHealthChecksVantagePointsResponse, String>(){

            public String apply(ListHealthChecksVantagePointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHealthChecksVantagePointsRequest.Builder>, ListHealthChecksVantagePointsRequest>(){

            public ListHealthChecksVantagePointsRequest apply(RequestBuilderAndToken<ListHealthChecksVantagePointsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHealthChecksVantagePointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHealthChecksVantagePointsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse>(){

            public ListHealthChecksVantagePointsResponse apply(ListHealthChecksVantagePointsRequest request) {
                return HealthChecksPaginators.this.client.listHealthChecksVantagePoints(request);
            }
        }, (Function)new Function<ListHealthChecksVantagePointsResponse, List<HealthChecksVantagePointSummary>>(){

            public List<HealthChecksVantagePointSummary> apply(ListHealthChecksVantagePointsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListHttpMonitorsResponse> listHttpMonitorsResponseIterator(final ListHttpMonitorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHttpMonitorsRequest.Builder>(){

            public ListHttpMonitorsRequest.Builder get() {
                return ListHttpMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpMonitorsResponse, String>(){

            public String apply(ListHttpMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpMonitorsRequest.Builder>, ListHttpMonitorsRequest>(){

            public ListHttpMonitorsRequest apply(RequestBuilderAndToken<ListHttpMonitorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHttpMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpMonitorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHttpMonitorsRequest, ListHttpMonitorsResponse>(){

            public ListHttpMonitorsResponse apply(ListHttpMonitorsRequest request) {
                return HealthChecksPaginators.this.client.listHttpMonitors(request);
            }
        });
    }

    public Iterable<HttpMonitorSummary> listHttpMonitorsRecordIterator(final ListHttpMonitorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHttpMonitorsRequest.Builder>(){

            public ListHttpMonitorsRequest.Builder get() {
                return ListHttpMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpMonitorsResponse, String>(){

            public String apply(ListHttpMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpMonitorsRequest.Builder>, ListHttpMonitorsRequest>(){

            public ListHttpMonitorsRequest apply(RequestBuilderAndToken<ListHttpMonitorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHttpMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpMonitorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHttpMonitorsRequest, ListHttpMonitorsResponse>(){

            public ListHttpMonitorsResponse apply(ListHttpMonitorsRequest request) {
                return HealthChecksPaginators.this.client.listHttpMonitors(request);
            }
        }, (Function)new Function<ListHttpMonitorsResponse, List<HttpMonitorSummary>>(){

            public List<HttpMonitorSummary> apply(ListHttpMonitorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListHttpProbeResultsResponse> listHttpProbeResultsResponseIterator(final ListHttpProbeResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHttpProbeResultsRequest.Builder>(){

            public ListHttpProbeResultsRequest.Builder get() {
                return ListHttpProbeResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpProbeResultsResponse, String>(){

            public String apply(ListHttpProbeResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpProbeResultsRequest.Builder>, ListHttpProbeResultsRequest>(){

            public ListHttpProbeResultsRequest apply(RequestBuilderAndToken<ListHttpProbeResultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHttpProbeResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpProbeResultsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse>(){

            public ListHttpProbeResultsResponse apply(ListHttpProbeResultsRequest request) {
                return HealthChecksPaginators.this.client.listHttpProbeResults(request);
            }
        });
    }

    public Iterable<HttpProbeResultSummary> listHttpProbeResultsRecordIterator(final ListHttpProbeResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHttpProbeResultsRequest.Builder>(){

            public ListHttpProbeResultsRequest.Builder get() {
                return ListHttpProbeResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpProbeResultsResponse, String>(){

            public String apply(ListHttpProbeResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpProbeResultsRequest.Builder>, ListHttpProbeResultsRequest>(){

            public ListHttpProbeResultsRequest apply(RequestBuilderAndToken<ListHttpProbeResultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHttpProbeResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpProbeResultsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse>(){

            public ListHttpProbeResultsResponse apply(ListHttpProbeResultsRequest request) {
                return HealthChecksPaginators.this.client.listHttpProbeResults(request);
            }
        }, (Function)new Function<ListHttpProbeResultsResponse, List<HttpProbeResultSummary>>(){

            public List<HttpProbeResultSummary> apply(ListHttpProbeResultsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPingMonitorsResponse> listPingMonitorsResponseIterator(final ListPingMonitorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPingMonitorsRequest.Builder>(){

            public ListPingMonitorsRequest.Builder get() {
                return ListPingMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPingMonitorsResponse, String>(){

            public String apply(ListPingMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPingMonitorsRequest.Builder>, ListPingMonitorsRequest>(){

            public ListPingMonitorsRequest apply(RequestBuilderAndToken<ListPingMonitorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPingMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPingMonitorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPingMonitorsRequest, ListPingMonitorsResponse>(){

            public ListPingMonitorsResponse apply(ListPingMonitorsRequest request) {
                return HealthChecksPaginators.this.client.listPingMonitors(request);
            }
        });
    }

    public Iterable<PingMonitorSummary> listPingMonitorsRecordIterator(final ListPingMonitorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPingMonitorsRequest.Builder>(){

            public ListPingMonitorsRequest.Builder get() {
                return ListPingMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPingMonitorsResponse, String>(){

            public String apply(ListPingMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPingMonitorsRequest.Builder>, ListPingMonitorsRequest>(){

            public ListPingMonitorsRequest apply(RequestBuilderAndToken<ListPingMonitorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPingMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPingMonitorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPingMonitorsRequest, ListPingMonitorsResponse>(){

            public ListPingMonitorsResponse apply(ListPingMonitorsRequest request) {
                return HealthChecksPaginators.this.client.listPingMonitors(request);
            }
        }, (Function)new Function<ListPingMonitorsResponse, List<PingMonitorSummary>>(){

            public List<PingMonitorSummary> apply(ListPingMonitorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPingProbeResultsResponse> listPingProbeResultsResponseIterator(final ListPingProbeResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPingProbeResultsRequest.Builder>(){

            public ListPingProbeResultsRequest.Builder get() {
                return ListPingProbeResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPingProbeResultsResponse, String>(){

            public String apply(ListPingProbeResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPingProbeResultsRequest.Builder>, ListPingProbeResultsRequest>(){

            public ListPingProbeResultsRequest apply(RequestBuilderAndToken<ListPingProbeResultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPingProbeResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPingProbeResultsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPingProbeResultsRequest, ListPingProbeResultsResponse>(){

            public ListPingProbeResultsResponse apply(ListPingProbeResultsRequest request) {
                return HealthChecksPaginators.this.client.listPingProbeResults(request);
            }
        });
    }

    public Iterable<PingProbeResultSummary> listPingProbeResultsRecordIterator(final ListPingProbeResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPingProbeResultsRequest.Builder>(){

            public ListPingProbeResultsRequest.Builder get() {
                return ListPingProbeResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPingProbeResultsResponse, String>(){

            public String apply(ListPingProbeResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPingProbeResultsRequest.Builder>, ListPingProbeResultsRequest>(){

            public ListPingProbeResultsRequest apply(RequestBuilderAndToken<ListPingProbeResultsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPingProbeResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPingProbeResultsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPingProbeResultsRequest, ListPingProbeResultsResponse>(){

            public ListPingProbeResultsResponse apply(ListPingProbeResultsRequest request) {
                return HealthChecksPaginators.this.client.listPingProbeResults(request);
            }
        }, (Function)new Function<ListPingProbeResultsResponse, List<PingProbeResultSummary>>(){

            public List<PingProbeResultSummary> apply(ListPingProbeResultsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public HealthChecksPaginators(HealthChecks client) {
        this.client = client;
    }
}

