/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteHttpMonitorRequest
extends BmcRequest<Void> {
    private String monitorId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"monitorId", "opcRequestId", "ifMatch"})
    DeleteHttpMonitorRequest(String monitorId, String opcRequestId, String ifMatch) {
        this.monitorId = monitorId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteHttpMonitorRequest, Void> {
        private String monitorId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteHttpMonitorRequest o) {
            this.monitorId(o.getMonitorId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteHttpMonitorRequest build() {
            DeleteHttpMonitorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteHttpMonitorRequest buildWithoutInvocationCallback() {
            return new DeleteHttpMonitorRequest(this.monitorId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeleteHttpMonitorRequest.Builder(monitorId=" + this.monitorId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

