/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListPingProbeResultsRequest
extends BmcRequest<Void> {
    private String probeConfigurationId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private Double startTimeGreaterThanOrEqualTo;
    private Double startTimeLessThanOrEqualTo;
    private SortOrder sortOrder;
    private String target;

    @ConstructorProperties(value={"probeConfigurationId", "opcRequestId", "limit", "page", "startTimeGreaterThanOrEqualTo", "startTimeLessThanOrEqualTo", "sortOrder", "target"})
    ListPingProbeResultsRequest(String probeConfigurationId, String opcRequestId, Integer limit, String page, Double startTimeGreaterThanOrEqualTo, Double startTimeLessThanOrEqualTo, SortOrder sortOrder, String target) {
        this.probeConfigurationId = probeConfigurationId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.startTimeGreaterThanOrEqualTo = startTimeGreaterThanOrEqualTo;
        this.startTimeLessThanOrEqualTo = startTimeLessThanOrEqualTo;
        this.sortOrder = sortOrder;
        this.target = target;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProbeConfigurationId() {
        return this.probeConfigurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Double getStartTimeGreaterThanOrEqualTo() {
        return this.startTimeGreaterThanOrEqualTo;
    }

    public Double getStartTimeLessThanOrEqualTo() {
        return this.startTimeLessThanOrEqualTo;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getTarget() {
        return this.target;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPingProbeResultsRequest, Void> {
        private String probeConfigurationId;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private Double startTimeGreaterThanOrEqualTo;
        private Double startTimeLessThanOrEqualTo;
        private SortOrder sortOrder;
        private String target;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPingProbeResultsRequest o) {
            this.probeConfigurationId(o.getProbeConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.startTimeGreaterThanOrEqualTo(o.getStartTimeGreaterThanOrEqualTo());
            this.startTimeLessThanOrEqualTo(o.getStartTimeLessThanOrEqualTo());
            this.sortOrder(o.getSortOrder());
            this.target(o.getTarget());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPingProbeResultsRequest build() {
            ListPingProbeResultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder probeConfigurationId(String probeConfigurationId) {
            this.probeConfigurationId = probeConfigurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder startTimeGreaterThanOrEqualTo(Double startTimeGreaterThanOrEqualTo) {
            this.startTimeGreaterThanOrEqualTo = startTimeGreaterThanOrEqualTo;
            return this;
        }

        public Builder startTimeLessThanOrEqualTo(Double startTimeLessThanOrEqualTo) {
            this.startTimeLessThanOrEqualTo = startTimeLessThanOrEqualTo;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public ListPingProbeResultsRequest buildWithoutInvocationCallback() {
            return new ListPingProbeResultsRequest(this.probeConfigurationId, this.opcRequestId, this.limit, this.page, this.startTimeGreaterThanOrEqualTo, this.startTimeLessThanOrEqualTo, this.sortOrder, this.target);
        }

        public String toString() {
            return "ListPingProbeResultsRequest.Builder(probeConfigurationId=" + this.probeConfigurationId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", startTimeGreaterThanOrEqualTo=" + this.startTimeGreaterThanOrEqualTo + ", startTimeLessThanOrEqualTo=" + this.startTimeLessThanOrEqualTo + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", target=" + this.target + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

