/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetHttpMonitorRequest
extends BmcRequest<Void> {
    private String monitorId;
    private String opcRequestId;
    private String ifNoneMatch;

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public Builder toBuilder() {
        return new Builder().monitorId(this.monitorId).opcRequestId(this.opcRequestId).ifNoneMatch(this.ifNoneMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",monitorId=").append(String.valueOf(this.monitorId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetHttpMonitorRequest)) {
            return false;
        }
        GetHttpMonitorRequest other = (GetHttpMonitorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.monitorId, other.monitorId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.monitorId == null ? 43 : this.monitorId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetHttpMonitorRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String monitorId = null;
        private String opcRequestId = null;
        private String ifNoneMatch = null;

        public Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetHttpMonitorRequest o) {
            this.monitorId(o.getMonitorId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetHttpMonitorRequest build() {
            GetHttpMonitorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetHttpMonitorRequest buildWithoutInvocationCallback() {
            GetHttpMonitorRequest request = new GetHttpMonitorRequest();
            request.monitorId = this.monitorId;
            request.opcRequestId = this.opcRequestId;
            request.ifNoneMatch = this.ifNoneMatch;
            return request;
        }
    }
}

