/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.healthchecks.HealthChecks;
import com.oracle.bmc.healthchecks.HealthChecksPaginators;
import com.oracle.bmc.healthchecks.model.HealthChecksVantagePointSummary;
import com.oracle.bmc.healthchecks.model.HttpMonitor;
import com.oracle.bmc.healthchecks.model.HttpMonitorSummary;
import com.oracle.bmc.healthchecks.model.HttpProbe;
import com.oracle.bmc.healthchecks.model.HttpProbeResultSummary;
import com.oracle.bmc.healthchecks.model.PingMonitor;
import com.oracle.bmc.healthchecks.model.PingMonitorSummary;
import com.oracle.bmc.healthchecks.model.PingProbe;
import com.oracle.bmc.healthchecks.model.PingProbeResultSummary;
import com.oracle.bmc.healthchecks.requests.ChangeHttpMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.requests.ChangePingMonitorCompartmentRequest;
import com.oracle.bmc.healthchecks.requests.CreateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandHttpProbeRequest;
import com.oracle.bmc.healthchecks.requests.CreateOnDemandPingProbeRequest;
import com.oracle.bmc.healthchecks.requests.CreatePingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.DeleteHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.DeletePingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.GetHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.GetPingMonitorRequest;
import com.oracle.bmc.healthchecks.requests.ListHealthChecksVantagePointsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.UpdateHttpMonitorRequest;
import com.oracle.bmc.healthchecks.requests.UpdatePingMonitorRequest;
import com.oracle.bmc.healthchecks.responses.ChangeHttpMonitorCompartmentResponse;
import com.oracle.bmc.healthchecks.responses.ChangePingMonitorCompartmentResponse;
import com.oracle.bmc.healthchecks.responses.CreateHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandHttpProbeResponse;
import com.oracle.bmc.healthchecks.responses.CreateOnDemandPingProbeResponse;
import com.oracle.bmc.healthchecks.responses.CreatePingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.DeleteHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.DeletePingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.GetHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.GetPingMonitorResponse;
import com.oracle.bmc.healthchecks.responses.ListHealthChecksVantagePointsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.UpdateHttpMonitorResponse;
import com.oracle.bmc.healthchecks.responses.UpdatePingMonitorResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecksClient
extends BaseSyncClient
implements HealthChecks {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("HEALTHCHECKS").serviceEndpointPrefix("healthchecks").serviceEndpointTemplate("https://healthchecks.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(HealthChecksClient.class);
    private final HealthChecksPaginators paginators = new HealthChecksPaginators(this);

    HealthChecksClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeHttpMonitorCompartmentResponse changeHttpMonitorCompartment(ChangeHttpMonitorCompartmentRequest request) {
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHttpMonitorCompartmentDetails(), "changeHttpMonitorCompartmentDetails is required");
        return (ChangeHttpMonitorCompartmentResponse)this.clientCall(request, ChangeHttpMonitorCompartmentResponse::builder).logger(LOG, "changeHttpMonitorCompartment").serviceDetails("HealthChecks", "ChangeHttpMonitorCompartment", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HttpMonitor/ChangeHttpMonitorCompartment").method(Method.POST).requestBuilder(ChangeHttpMonitorCompartmentRequest::builder).basePath("/20180501").appendPathParam("httpMonitors").appendPathParam(request.getMonitorId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHttpMonitorCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangePingMonitorCompartmentResponse changePingMonitorCompartment(ChangePingMonitorCompartmentRequest request) {
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePingMonitorCompartmentDetails(), "changePingMonitorCompartmentDetails is required");
        return (ChangePingMonitorCompartmentResponse)this.clientCall(request, ChangePingMonitorCompartmentResponse::builder).logger(LOG, "changePingMonitorCompartment").serviceDetails("HealthChecks", "ChangePingMonitorCompartment", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/PingMonitor/ChangePingMonitorCompartment").method(Method.POST).requestBuilder(ChangePingMonitorCompartmentRequest::builder).basePath("/20180501").appendPathParam("pingMonitors").appendPathParam(request.getMonitorId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangePingMonitorCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateHttpMonitorResponse createHttpMonitor(CreateHttpMonitorRequest request) {
        Objects.requireNonNull(request.getCreateHttpMonitorDetails(), "createHttpMonitorDetails is required");
        return (CreateHttpMonitorResponse)this.clientCall(request, CreateHttpMonitorResponse::builder).logger(LOG, "createHttpMonitor").serviceDetails("HealthChecks", "CreateHttpMonitor", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HttpMonitor/CreateHttpMonitor").method(Method.POST).requestBuilder(CreateHttpMonitorRequest::builder).basePath("/20180501").appendPathParam("httpMonitors").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(HttpMonitor.class, CreateHttpMonitorResponse.Builder::httpMonitor).handleResponseHeaderString("opc-request-id", CreateHttpMonitorResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateHttpMonitorResponse.Builder::location).handleResponseHeaderString("etag", CreateHttpMonitorResponse.Builder::etag).callSync();
    }

    @Override
    public CreateOnDemandHttpProbeResponse createOnDemandHttpProbe(CreateOnDemandHttpProbeRequest request) {
        Objects.requireNonNull(request.getCreateOnDemandHttpProbeDetails(), "createOnDemandHttpProbeDetails is required");
        return (CreateOnDemandHttpProbeResponse)this.clientCall(request, CreateOnDemandHttpProbeResponse::builder).logger(LOG, "createOnDemandHttpProbe").serviceDetails("HealthChecks", "CreateOnDemandHttpProbe", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HttpProbe/CreateOnDemandHttpProbe").method(Method.POST).requestBuilder(CreateOnDemandHttpProbeRequest::builder).basePath("/20180501").appendPathParam("httpProbeResults").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(HttpProbe.class, CreateOnDemandHttpProbeResponse.Builder::httpProbe).handleResponseHeaderString("opc-request-id", CreateOnDemandHttpProbeResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateOnDemandHttpProbeResponse.Builder::location).callSync();
    }

    @Override
    public CreateOnDemandPingProbeResponse createOnDemandPingProbe(CreateOnDemandPingProbeRequest request) {
        Objects.requireNonNull(request.getCreateOnDemandPingProbeDetails(), "createOnDemandPingProbeDetails is required");
        return (CreateOnDemandPingProbeResponse)this.clientCall(request, CreateOnDemandPingProbeResponse::builder).logger(LOG, "createOnDemandPingProbe").serviceDetails("HealthChecks", "CreateOnDemandPingProbe", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/PingProbe/CreateOnDemandPingProbe").method(Method.POST).requestBuilder(CreateOnDemandPingProbeRequest::builder).basePath("/20180501").appendPathParam("pingProbeResults").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PingProbe.class, CreateOnDemandPingProbeResponse.Builder::pingProbe).handleResponseHeaderString("opc-request-id", CreateOnDemandPingProbeResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateOnDemandPingProbeResponse.Builder::location).callSync();
    }

    @Override
    public CreatePingMonitorResponse createPingMonitor(CreatePingMonitorRequest request) {
        Objects.requireNonNull(request.getCreatePingMonitorDetails(), "createPingMonitorDetails is required");
        return (CreatePingMonitorResponse)this.clientCall(request, CreatePingMonitorResponse::builder).logger(LOG, "createPingMonitor").serviceDetails("HealthChecks", "CreatePingMonitor", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/PingMonitor/CreatePingMonitor").method(Method.POST).requestBuilder(CreatePingMonitorRequest::builder).basePath("/20180501").appendPathParam("pingMonitors").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PingMonitor.class, CreatePingMonitorResponse.Builder::pingMonitor).handleResponseHeaderString("opc-request-id", CreatePingMonitorResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreatePingMonitorResponse.Builder::location).handleResponseHeaderString("etag", CreatePingMonitorResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteHttpMonitorResponse deleteHttpMonitor(DeleteHttpMonitorRequest request) {
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        return (DeleteHttpMonitorResponse)this.clientCall(request, DeleteHttpMonitorResponse::builder).logger(LOG, "deleteHttpMonitor").serviceDetails("HealthChecks", "DeleteHttpMonitor", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HttpMonitor/DeleteHttpMonitor").method(Method.DELETE).requestBuilder(DeleteHttpMonitorRequest::builder).basePath("/20180501").appendPathParam("httpMonitors").appendPathParam(request.getMonitorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteHttpMonitorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePingMonitorResponse deletePingMonitor(DeletePingMonitorRequest request) {
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        return (DeletePingMonitorResponse)this.clientCall(request, DeletePingMonitorResponse::builder).logger(LOG, "deletePingMonitor").serviceDetails("HealthChecks", "DeletePingMonitor", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/PingMonitor/DeletePingMonitor").method(Method.DELETE).requestBuilder(DeletePingMonitorRequest::builder).basePath("/20180501").appendPathParam("pingMonitors").appendPathParam(request.getMonitorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePingMonitorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHttpMonitorResponse getHttpMonitor(GetHttpMonitorRequest request) {
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        return (GetHttpMonitorResponse)this.clientCall(request, GetHttpMonitorResponse::builder).logger(LOG, "getHttpMonitor").serviceDetails("HealthChecks", "GetHttpMonitor", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HttpMonitor/GetHttpMonitor").method(Method.GET).requestBuilder(GetHttpMonitorRequest::builder).basePath("/20180501").appendPathParam("httpMonitors").appendPathParam(request.getMonitorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(HttpMonitor.class, GetHttpMonitorResponse.Builder::httpMonitor).handleResponseHeaderString("opc-request-id", GetHttpMonitorResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetHttpMonitorResponse.Builder::etag).callSync();
    }

    @Override
    public GetPingMonitorResponse getPingMonitor(GetPingMonitorRequest request) {
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        return (GetPingMonitorResponse)this.clientCall(request, GetPingMonitorResponse::builder).logger(LOG, "getPingMonitor").serviceDetails("HealthChecks", "GetPingMonitor", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/PingMonitor/GetPingMonitor").method(Method.GET).requestBuilder(GetPingMonitorRequest::builder).basePath("/20180501").appendPathParam("pingMonitors").appendPathParam(request.getMonitorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(PingMonitor.class, GetPingMonitorResponse.Builder::pingMonitor).handleResponseHeaderString("opc-request-id", GetPingMonitorResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetPingMonitorResponse.Builder::etag).callSync();
    }

    @Override
    public ListHealthChecksVantagePointsResponse listHealthChecksVantagePoints(ListHealthChecksVantagePointsRequest request) {
        return (ListHealthChecksVantagePointsResponse)this.clientCall(request, ListHealthChecksVantagePointsResponse::builder).logger(LOG, "listHealthChecksVantagePoints").serviceDetails("HealthChecks", "ListHealthChecksVantagePoints", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HealthChecksVantagePointSummary/ListHealthChecksVantagePoints").method(Method.GET).requestBuilder(ListHealthChecksVantagePointsRequest::builder).basePath("/20180501").appendPathParam("vantagePoints").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(HealthChecksVantagePointSummary.class, ListHealthChecksVantagePointsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListHealthChecksVantagePointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHealthChecksVantagePointsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHttpMonitorsResponse listHttpMonitors(ListHttpMonitorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHttpMonitorsResponse)this.clientCall(request, ListHttpMonitorsResponse::builder).logger(LOG, "listHttpMonitors").serviceDetails("HealthChecks", "ListHttpMonitors", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HttpMonitorSummary/ListHttpMonitors").method(Method.GET).requestBuilder(ListHttpMonitorsRequest::builder).basePath("/20180501").appendPathParam("httpMonitors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("homeRegion", (Object)request.getHomeRegion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(HttpMonitorSummary.class, ListHttpMonitorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListHttpMonitorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHttpMonitorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHttpProbeResultsResponse listHttpProbeResults(ListHttpProbeResultsRequest request) {
        Validate.notBlank((String)request.getProbeConfigurationId(), (String)"probeConfigurationId must not be blank", (Object[])new Object[0]);
        return (ListHttpProbeResultsResponse)this.clientCall(request, ListHttpProbeResultsResponse::builder).logger(LOG, "listHttpProbeResults").serviceDetails("HealthChecks", "ListHttpProbeResults", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HttpProbeResultSummary/ListHttpProbeResults").method(Method.GET).requestBuilder(ListHttpProbeResultsRequest::builder).basePath("/20180501").appendPathParam("httpProbeResults").appendPathParam(request.getProbeConfigurationId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("startTimeGreaterThanOrEqualTo", (Object)request.getStartTimeGreaterThanOrEqualTo()).appendQueryParam("startTimeLessThanOrEqualTo", (Object)request.getStartTimeLessThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("target", (Object)request.getTarget()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(HttpProbeResultSummary.class, ListHttpProbeResultsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListHttpProbeResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHttpProbeResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPingMonitorsResponse listPingMonitors(ListPingMonitorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPingMonitorsResponse)this.clientCall(request, ListPingMonitorsResponse::builder).logger(LOG, "listPingMonitors").serviceDetails("HealthChecks", "ListPingMonitors", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/PingMonitorSummary/ListPingMonitors").method(Method.GET).requestBuilder(ListPingMonitorsRequest::builder).basePath("/20180501").appendPathParam("pingMonitors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("homeRegion", (Object)request.getHomeRegion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PingMonitorSummary.class, ListPingMonitorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPingMonitorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPingMonitorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPingProbeResultsResponse listPingProbeResults(ListPingProbeResultsRequest request) {
        Validate.notBlank((String)request.getProbeConfigurationId(), (String)"probeConfigurationId must not be blank", (Object[])new Object[0]);
        return (ListPingProbeResultsResponse)this.clientCall(request, ListPingProbeResultsResponse::builder).logger(LOG, "listPingProbeResults").serviceDetails("HealthChecks", "ListPingProbeResults", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/PingProbeResultSummary/ListPingProbeResults").method(Method.GET).requestBuilder(ListPingProbeResultsRequest::builder).basePath("/20180501").appendPathParam("pingProbeResults").appendPathParam(request.getProbeConfigurationId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("startTimeGreaterThanOrEqualTo", (Object)request.getStartTimeGreaterThanOrEqualTo()).appendQueryParam("startTimeLessThanOrEqualTo", (Object)request.getStartTimeLessThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("target", (Object)request.getTarget()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PingProbeResultSummary.class, ListPingProbeResultsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPingProbeResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPingProbeResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateHttpMonitorResponse updateHttpMonitor(UpdateHttpMonitorRequest request) {
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHttpMonitorDetails(), "updateHttpMonitorDetails is required");
        return (UpdateHttpMonitorResponse)this.clientCall(request, UpdateHttpMonitorResponse::builder).logger(LOG, "updateHttpMonitor").serviceDetails("HealthChecks", "UpdateHttpMonitor", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/HttpMonitor/UpdateHttpMonitor").method(Method.PUT).requestBuilder(UpdateHttpMonitorRequest::builder).basePath("/20180501").appendPathParam("httpMonitors").appendPathParam(request.getMonitorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(HttpMonitor.class, UpdateHttpMonitorResponse.Builder::httpMonitor).handleResponseHeaderString("opc-request-id", UpdateHttpMonitorResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateHttpMonitorResponse.Builder::etag).callSync();
    }

    @Override
    public UpdatePingMonitorResponse updatePingMonitor(UpdatePingMonitorRequest request) {
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePingMonitorDetails(), "updatePingMonitorDetails is required");
        return (UpdatePingMonitorResponse)this.clientCall(request, UpdatePingMonitorResponse::builder).logger(LOG, "updatePingMonitor").serviceDetails("HealthChecks", "UpdatePingMonitor", "https://docs.oracle.com/iaas/api/#/en/healthchecks/20180501/PingMonitor/UpdatePingMonitor").method(Method.PUT).requestBuilder(UpdatePingMonitorRequest::builder).basePath("/20180501").appendPathParam("pingMonitors").appendPathParam(request.getMonitorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PingMonitor.class, UpdatePingMonitorResponse.Builder::pingMonitor).handleResponseHeaderString("opc-request-id", UpdatePingMonitorResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdatePingMonitorResponse.Builder::etag).callSync();
    }

    @Override
    public HealthChecksPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public HealthChecksClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)HealthChecksClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public HealthChecksClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(HealthChecksClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public HealthChecksClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)HealthChecksClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public HealthChecksClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)HealthChecksClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public HealthChecksClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)HealthChecksClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public HealthChecksClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)HealthChecksClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public HealthChecksClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)HealthChecksClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, HealthChecksClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "healthchecks";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"healthchecks");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public HealthChecksClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new HealthChecksClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

