/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks;

import com.oracle.bmc.healthchecks.HealthChecks;
import com.oracle.bmc.healthchecks.model.HealthChecksVantagePointSummary;
import com.oracle.bmc.healthchecks.model.HttpMonitorSummary;
import com.oracle.bmc.healthchecks.model.HttpProbeResultSummary;
import com.oracle.bmc.healthchecks.model.PingMonitorSummary;
import com.oracle.bmc.healthchecks.model.PingProbeResultSummary;
import com.oracle.bmc.healthchecks.requests.ListHealthChecksVantagePointsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListHttpProbeResultsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingMonitorsRequest;
import com.oracle.bmc.healthchecks.requests.ListPingProbeResultsRequest;
import com.oracle.bmc.healthchecks.responses.ListHealthChecksVantagePointsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListHttpProbeResultsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingMonitorsResponse;
import com.oracle.bmc.healthchecks.responses.ListPingProbeResultsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class HealthChecksPaginators {
    private final HealthChecks client;

    public HealthChecksPaginators(HealthChecks client) {
        this.client = client;
    }

    public Iterable<ListHealthChecksVantagePointsResponse> listHealthChecksVantagePointsResponseIterator(final ListHealthChecksVantagePointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHealthChecksVantagePointsRequest.Builder>(){

            @Override
            public ListHealthChecksVantagePointsRequest.Builder get() {
                return ListHealthChecksVantagePointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHealthChecksVantagePointsResponse, String>(){

            @Override
            public String apply(ListHealthChecksVantagePointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHealthChecksVantagePointsRequest.Builder>, ListHealthChecksVantagePointsRequest>(){

            @Override
            public ListHealthChecksVantagePointsRequest apply(RequestBuilderAndToken<ListHealthChecksVantagePointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHealthChecksVantagePointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHealthChecksVantagePointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse>(){

            @Override
            public ListHealthChecksVantagePointsResponse apply(ListHealthChecksVantagePointsRequest request) {
                return HealthChecksPaginators.this.client.listHealthChecksVantagePoints(request);
            }
        });
    }

    public Iterable<HealthChecksVantagePointSummary> listHealthChecksVantagePointsRecordIterator(final ListHealthChecksVantagePointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHealthChecksVantagePointsRequest.Builder>(){

            @Override
            public ListHealthChecksVantagePointsRequest.Builder get() {
                return ListHealthChecksVantagePointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHealthChecksVantagePointsResponse, String>(){

            @Override
            public String apply(ListHealthChecksVantagePointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHealthChecksVantagePointsRequest.Builder>, ListHealthChecksVantagePointsRequest>(){

            @Override
            public ListHealthChecksVantagePointsRequest apply(RequestBuilderAndToken<ListHealthChecksVantagePointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHealthChecksVantagePointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHealthChecksVantagePointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHealthChecksVantagePointsRequest, ListHealthChecksVantagePointsResponse>(){

            @Override
            public ListHealthChecksVantagePointsResponse apply(ListHealthChecksVantagePointsRequest request) {
                return HealthChecksPaginators.this.client.listHealthChecksVantagePoints(request);
            }
        }, (Function)new Function<ListHealthChecksVantagePointsResponse, List<HealthChecksVantagePointSummary>>(){

            @Override
            public List<HealthChecksVantagePointSummary> apply(ListHealthChecksVantagePointsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListHttpMonitorsResponse> listHttpMonitorsResponseIterator(final ListHttpMonitorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHttpMonitorsRequest.Builder>(){

            @Override
            public ListHttpMonitorsRequest.Builder get() {
                return ListHttpMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpMonitorsResponse, String>(){

            @Override
            public String apply(ListHttpMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpMonitorsRequest.Builder>, ListHttpMonitorsRequest>(){

            @Override
            public ListHttpMonitorsRequest apply(RequestBuilderAndToken<ListHttpMonitorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHttpMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpMonitorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHttpMonitorsRequest, ListHttpMonitorsResponse>(){

            @Override
            public ListHttpMonitorsResponse apply(ListHttpMonitorsRequest request) {
                return HealthChecksPaginators.this.client.listHttpMonitors(request);
            }
        });
    }

    public Iterable<HttpMonitorSummary> listHttpMonitorsRecordIterator(final ListHttpMonitorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHttpMonitorsRequest.Builder>(){

            @Override
            public ListHttpMonitorsRequest.Builder get() {
                return ListHttpMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpMonitorsResponse, String>(){

            @Override
            public String apply(ListHttpMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpMonitorsRequest.Builder>, ListHttpMonitorsRequest>(){

            @Override
            public ListHttpMonitorsRequest apply(RequestBuilderAndToken<ListHttpMonitorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHttpMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpMonitorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHttpMonitorsRequest, ListHttpMonitorsResponse>(){

            @Override
            public ListHttpMonitorsResponse apply(ListHttpMonitorsRequest request) {
                return HealthChecksPaginators.this.client.listHttpMonitors(request);
            }
        }, (Function)new Function<ListHttpMonitorsResponse, List<HttpMonitorSummary>>(){

            @Override
            public List<HttpMonitorSummary> apply(ListHttpMonitorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListHttpProbeResultsResponse> listHttpProbeResultsResponseIterator(final ListHttpProbeResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHttpProbeResultsRequest.Builder>(){

            @Override
            public ListHttpProbeResultsRequest.Builder get() {
                return ListHttpProbeResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpProbeResultsResponse, String>(){

            @Override
            public String apply(ListHttpProbeResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpProbeResultsRequest.Builder>, ListHttpProbeResultsRequest>(){

            @Override
            public ListHttpProbeResultsRequest apply(RequestBuilderAndToken<ListHttpProbeResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHttpProbeResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpProbeResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse>(){

            @Override
            public ListHttpProbeResultsResponse apply(ListHttpProbeResultsRequest request) {
                return HealthChecksPaginators.this.client.listHttpProbeResults(request);
            }
        });
    }

    public Iterable<HttpProbeResultSummary> listHttpProbeResultsRecordIterator(final ListHttpProbeResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHttpProbeResultsRequest.Builder>(){

            @Override
            public ListHttpProbeResultsRequest.Builder get() {
                return ListHttpProbeResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpProbeResultsResponse, String>(){

            @Override
            public String apply(ListHttpProbeResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpProbeResultsRequest.Builder>, ListHttpProbeResultsRequest>(){

            @Override
            public ListHttpProbeResultsRequest apply(RequestBuilderAndToken<ListHttpProbeResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHttpProbeResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpProbeResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHttpProbeResultsRequest, ListHttpProbeResultsResponse>(){

            @Override
            public ListHttpProbeResultsResponse apply(ListHttpProbeResultsRequest request) {
                return HealthChecksPaginators.this.client.listHttpProbeResults(request);
            }
        }, (Function)new Function<ListHttpProbeResultsResponse, List<HttpProbeResultSummary>>(){

            @Override
            public List<HttpProbeResultSummary> apply(ListHttpProbeResultsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPingMonitorsResponse> listPingMonitorsResponseIterator(final ListPingMonitorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPingMonitorsRequest.Builder>(){

            @Override
            public ListPingMonitorsRequest.Builder get() {
                return ListPingMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPingMonitorsResponse, String>(){

            @Override
            public String apply(ListPingMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPingMonitorsRequest.Builder>, ListPingMonitorsRequest>(){

            @Override
            public ListPingMonitorsRequest apply(RequestBuilderAndToken<ListPingMonitorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPingMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPingMonitorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPingMonitorsRequest, ListPingMonitorsResponse>(){

            @Override
            public ListPingMonitorsResponse apply(ListPingMonitorsRequest request) {
                return HealthChecksPaginators.this.client.listPingMonitors(request);
            }
        });
    }

    public Iterable<PingMonitorSummary> listPingMonitorsRecordIterator(final ListPingMonitorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPingMonitorsRequest.Builder>(){

            @Override
            public ListPingMonitorsRequest.Builder get() {
                return ListPingMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPingMonitorsResponse, String>(){

            @Override
            public String apply(ListPingMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPingMonitorsRequest.Builder>, ListPingMonitorsRequest>(){

            @Override
            public ListPingMonitorsRequest apply(RequestBuilderAndToken<ListPingMonitorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPingMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPingMonitorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPingMonitorsRequest, ListPingMonitorsResponse>(){

            @Override
            public ListPingMonitorsResponse apply(ListPingMonitorsRequest request) {
                return HealthChecksPaginators.this.client.listPingMonitors(request);
            }
        }, (Function)new Function<ListPingMonitorsResponse, List<PingMonitorSummary>>(){

            @Override
            public List<PingMonitorSummary> apply(ListPingMonitorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPingProbeResultsResponse> listPingProbeResultsResponseIterator(final ListPingProbeResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPingProbeResultsRequest.Builder>(){

            @Override
            public ListPingProbeResultsRequest.Builder get() {
                return ListPingProbeResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPingProbeResultsResponse, String>(){

            @Override
            public String apply(ListPingProbeResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPingProbeResultsRequest.Builder>, ListPingProbeResultsRequest>(){

            @Override
            public ListPingProbeResultsRequest apply(RequestBuilderAndToken<ListPingProbeResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPingProbeResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPingProbeResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPingProbeResultsRequest, ListPingProbeResultsResponse>(){

            @Override
            public ListPingProbeResultsResponse apply(ListPingProbeResultsRequest request) {
                return HealthChecksPaginators.this.client.listPingProbeResults(request);
            }
        });
    }

    public Iterable<PingProbeResultSummary> listPingProbeResultsRecordIterator(final ListPingProbeResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPingProbeResultsRequest.Builder>(){

            @Override
            public ListPingProbeResultsRequest.Builder get() {
                return ListPingProbeResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPingProbeResultsResponse, String>(){

            @Override
            public String apply(ListPingProbeResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPingProbeResultsRequest.Builder>, ListPingProbeResultsRequest>(){

            @Override
            public ListPingProbeResultsRequest apply(RequestBuilderAndToken<ListPingProbeResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPingProbeResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPingProbeResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPingProbeResultsRequest, ListPingProbeResultsResponse>(){

            @Override
            public ListPingProbeResultsResponse apply(ListPingProbeResultsRequest request) {
                return HealthChecksPaginators.this.client.listPingProbeResults(request);
            }
        }, (Function)new Function<ListPingProbeResultsResponse, List<PingProbeResultSummary>>(){

            @Override
            public List<PingProbeResultSummary> apply(ListPingProbeResultsResponse response) {
                return response.getItems();
            }
        });
    }
}

