/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Routing
extends ExplicitlySetBmcModel {
    @JsonProperty(value="asLabel")
    private final String asLabel;
    @JsonProperty(value="asn")
    private final Integer asn;
    @JsonProperty(value="prefix")
    private final String prefix;
    @JsonProperty(value="weight")
    private final Integer weight;

    @Deprecated
    @ConstructorProperties(value={"asLabel", "asn", "prefix", "weight"})
    public Routing(String asLabel, Integer asn, String prefix, Integer weight) {
        this.asLabel = asLabel;
        this.asn = asn;
        this.prefix = prefix;
        this.weight = weight;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAsLabel() {
        return this.asLabel;
    }

    public Integer getAsn() {
        return this.asn;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Routing(");
        sb.append("super=").append(super.toString());
        sb.append("asLabel=").append(String.valueOf(this.asLabel));
        sb.append(", asn=").append(String.valueOf(this.asn));
        sb.append(", prefix=").append(String.valueOf(this.prefix));
        sb.append(", weight=").append(String.valueOf(this.weight));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Routing)) {
            return false;
        }
        Routing other = (Routing)((Object)o);
        return Objects.equals(this.asLabel, other.asLabel) && Objects.equals(this.asn, other.asn) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.weight, other.weight) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.asLabel == null ? 43 : this.asLabel.hashCode());
        result = result * 59 + (this.asn == null ? 43 : this.asn.hashCode());
        result = result * 59 + (this.prefix == null ? 43 : this.prefix.hashCode());
        result = result * 59 + (this.weight == null ? 43 : this.weight.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="asLabel")
        private String asLabel;
        @JsonProperty(value="asn")
        private Integer asn;
        @JsonProperty(value="prefix")
        private String prefix;
        @JsonProperty(value="weight")
        private Integer weight;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder asLabel(String asLabel) {
            this.asLabel = asLabel;
            this.__explicitlySet__.add("asLabel");
            return this;
        }

        public Builder asn(Integer asn) {
            this.asn = asn;
            this.__explicitlySet__.add("asn");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.__explicitlySet__.add("prefix");
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            this.__explicitlySet__.add("weight");
            return this;
        }

        public Routing build() {
            Routing model = new Routing(this.asLabel, this.asn, this.prefix, this.weight);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Routing model) {
            if (model.wasPropertyExplicitlySet("asLabel")) {
                this.asLabel(model.getAsLabel());
            }
            if (model.wasPropertyExplicitlySet("asn")) {
                this.asn(model.getAsn());
            }
            if (model.wasPropertyExplicitlySet("prefix")) {
                this.prefix(model.getPrefix());
            }
            if (model.wasPropertyExplicitlySet("weight")) {
                this.weight(model.getWeight());
            }
            return this;
        }
    }
}

