/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.healthchecks.model.CreateHttpMonitorDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateHttpMonitorRequest
extends BmcRequest<CreateHttpMonitorDetails> {
    private CreateHttpMonitorDetails createHttpMonitorDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public CreateHttpMonitorDetails getCreateHttpMonitorDetails() {
        return this.createHttpMonitorDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateHttpMonitorDetails getBody$() {
        return this.createHttpMonitorDetails;
    }

    public Builder toBuilder() {
        return new Builder().createHttpMonitorDetails(this.createHttpMonitorDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createHttpMonitorDetails=").append(String.valueOf((Object)this.createHttpMonitorDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateHttpMonitorRequest)) {
            return false;
        }
        CreateHttpMonitorRequest other = (CreateHttpMonitorRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createHttpMonitorDetails, (Object)other.createHttpMonitorDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createHttpMonitorDetails == null ? 43 : this.createHttpMonitorDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateHttpMonitorRequest, CreateHttpMonitorDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateHttpMonitorDetails createHttpMonitorDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder createHttpMonitorDetails(CreateHttpMonitorDetails createHttpMonitorDetails) {
            this.createHttpMonitorDetails = createHttpMonitorDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateHttpMonitorRequest o) {
            this.createHttpMonitorDetails(o.getCreateHttpMonitorDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateHttpMonitorRequest build() {
            CreateHttpMonitorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateHttpMonitorDetails body) {
            this.createHttpMonitorDetails(body);
            return this;
        }

        public CreateHttpMonitorRequest buildWithoutInvocationCallback() {
            CreateHttpMonitorRequest request = new CreateHttpMonitorRequest();
            request.createHttpMonitorDetails = this.createHttpMonitorDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

