/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.healthchecks.model.Connection;
import com.oracle.bmc.healthchecks.model.DNS;
import com.oracle.bmc.healthchecks.model.PingProbeProtocol;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PingProbeResultSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="probeConfigurationId")
    private final String probeConfigurationId;
    @JsonProperty(value="startTime")
    private final Double startTime;
    @JsonProperty(value="target")
    private final String target;
    @JsonProperty(value="vantagePointName")
    private final String vantagePointName;
    @JsonProperty(value="isTimedOut")
    private final Boolean isTimedOut;
    @JsonProperty(value="isHealthy")
    private final Boolean isHealthy;
    @JsonProperty(value="errorCategory")
    private final ErrorCategory errorCategory;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="protocol")
    private final PingProbeProtocol protocol;
    @JsonProperty(value="connection")
    private final Connection connection;
    @JsonProperty(value="dns")
    private final DNS dns;
    @JsonProperty(value="domainLookupStart")
    private final Double domainLookupStart;
    @JsonProperty(value="domainLookupEnd")
    private final Double domainLookupEnd;
    @JsonProperty(value="latencyInMs")
    private final Double latencyInMs;
    @JsonProperty(value="icmpCode")
    private final Integer icmpCode;

    @Deprecated
    @ConstructorProperties(value={"key", "probeConfigurationId", "startTime", "target", "vantagePointName", "isTimedOut", "isHealthy", "errorCategory", "errorMessage", "protocol", "connection", "dns", "domainLookupStart", "domainLookupEnd", "latencyInMs", "icmpCode"})
    public PingProbeResultSummary(String key, String probeConfigurationId, Double startTime, String target, String vantagePointName, Boolean isTimedOut, Boolean isHealthy, ErrorCategory errorCategory, String errorMessage, PingProbeProtocol protocol, Connection connection, DNS dns, Double domainLookupStart, Double domainLookupEnd, Double latencyInMs, Integer icmpCode) {
        this.key = key;
        this.probeConfigurationId = probeConfigurationId;
        this.startTime = startTime;
        this.target = target;
        this.vantagePointName = vantagePointName;
        this.isTimedOut = isTimedOut;
        this.isHealthy = isHealthy;
        this.errorCategory = errorCategory;
        this.errorMessage = errorMessage;
        this.protocol = protocol;
        this.connection = connection;
        this.dns = dns;
        this.domainLookupStart = domainLookupStart;
        this.domainLookupEnd = domainLookupEnd;
        this.latencyInMs = latencyInMs;
        this.icmpCode = icmpCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getProbeConfigurationId() {
        return this.probeConfigurationId;
    }

    public Double getStartTime() {
        return this.startTime;
    }

    public String getTarget() {
        return this.target;
    }

    public String getVantagePointName() {
        return this.vantagePointName;
    }

    public Boolean getIsTimedOut() {
        return this.isTimedOut;
    }

    public Boolean getIsHealthy() {
        return this.isHealthy;
    }

    public ErrorCategory getErrorCategory() {
        return this.errorCategory;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public PingProbeProtocol getProtocol() {
        return this.protocol;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DNS getDns() {
        return this.dns;
    }

    public Double getDomainLookupStart() {
        return this.domainLookupStart;
    }

    public Double getDomainLookupEnd() {
        return this.domainLookupEnd;
    }

    public Double getLatencyInMs() {
        return this.latencyInMs;
    }

    public Integer getIcmpCode() {
        return this.icmpCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PingProbeResultSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", probeConfigurationId=").append(String.valueOf(this.probeConfigurationId));
        sb.append(", startTime=").append(String.valueOf(this.startTime));
        sb.append(", target=").append(String.valueOf(this.target));
        sb.append(", vantagePointName=").append(String.valueOf(this.vantagePointName));
        sb.append(", isTimedOut=").append(String.valueOf(this.isTimedOut));
        sb.append(", isHealthy=").append(String.valueOf(this.isHealthy));
        sb.append(", errorCategory=").append(String.valueOf((Object)this.errorCategory));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", connection=").append(String.valueOf((Object)this.connection));
        sb.append(", dns=").append(String.valueOf((Object)this.dns));
        sb.append(", domainLookupStart=").append(String.valueOf(this.domainLookupStart));
        sb.append(", domainLookupEnd=").append(String.valueOf(this.domainLookupEnd));
        sb.append(", latencyInMs=").append(String.valueOf(this.latencyInMs));
        sb.append(", icmpCode=").append(String.valueOf(this.icmpCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PingProbeResultSummary)) {
            return false;
        }
        PingProbeResultSummary other = (PingProbeResultSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.probeConfigurationId, other.probeConfigurationId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.target, other.target) && Objects.equals(this.vantagePointName, other.vantagePointName) && Objects.equals(this.isTimedOut, other.isTimedOut) && Objects.equals(this.isHealthy, other.isHealthy) && Objects.equals((Object)this.errorCategory, (Object)other.errorCategory) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals((Object)this.connection, (Object)other.connection) && Objects.equals((Object)this.dns, (Object)other.dns) && Objects.equals(this.domainLookupStart, other.domainLookupStart) && Objects.equals(this.domainLookupEnd, other.domainLookupEnd) && Objects.equals(this.latencyInMs, other.latencyInMs) && Objects.equals(this.icmpCode, other.icmpCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.probeConfigurationId == null ? 43 : this.probeConfigurationId.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.vantagePointName == null ? 43 : this.vantagePointName.hashCode());
        result = result * 59 + (this.isTimedOut == null ? 43 : this.isTimedOut.hashCode());
        result = result * 59 + (this.isHealthy == null ? 43 : this.isHealthy.hashCode());
        result = result * 59 + (this.errorCategory == null ? 43 : this.errorCategory.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.connection == null ? 43 : this.connection.hashCode());
        result = result * 59 + (this.dns == null ? 43 : this.dns.hashCode());
        result = result * 59 + (this.domainLookupStart == null ? 43 : this.domainLookupStart.hashCode());
        result = result * 59 + (this.domainLookupEnd == null ? 43 : this.domainLookupEnd.hashCode());
        result = result * 59 + (this.latencyInMs == null ? 43 : this.latencyInMs.hashCode());
        result = result * 59 + (this.icmpCode == null ? 43 : this.icmpCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ErrorCategory implements BmcEnum
    {
        None("NONE"),
        Dns("DNS"),
        Transport("TRANSPORT"),
        Network("NETWORK"),
        System("SYSTEM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ErrorCategory> map;

        private ErrorCategory(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ErrorCategory create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ErrorCategory', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ErrorCategory.class);
            map = new HashMap<String, ErrorCategory>();
            for (ErrorCategory v : ErrorCategory.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="probeConfigurationId")
        private String probeConfigurationId;
        @JsonProperty(value="startTime")
        private Double startTime;
        @JsonProperty(value="target")
        private String target;
        @JsonProperty(value="vantagePointName")
        private String vantagePointName;
        @JsonProperty(value="isTimedOut")
        private Boolean isTimedOut;
        @JsonProperty(value="isHealthy")
        private Boolean isHealthy;
        @JsonProperty(value="errorCategory")
        private ErrorCategory errorCategory;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="protocol")
        private PingProbeProtocol protocol;
        @JsonProperty(value="connection")
        private Connection connection;
        @JsonProperty(value="dns")
        private DNS dns;
        @JsonProperty(value="domainLookupStart")
        private Double domainLookupStart;
        @JsonProperty(value="domainLookupEnd")
        private Double domainLookupEnd;
        @JsonProperty(value="latencyInMs")
        private Double latencyInMs;
        @JsonProperty(value="icmpCode")
        private Integer icmpCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder probeConfigurationId(String probeConfigurationId) {
            this.probeConfigurationId = probeConfigurationId;
            this.__explicitlySet__.add("probeConfigurationId");
            return this;
        }

        public Builder startTime(Double startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder vantagePointName(String vantagePointName) {
            this.vantagePointName = vantagePointName;
            this.__explicitlySet__.add("vantagePointName");
            return this;
        }

        public Builder isTimedOut(Boolean isTimedOut) {
            this.isTimedOut = isTimedOut;
            this.__explicitlySet__.add("isTimedOut");
            return this;
        }

        public Builder isHealthy(Boolean isHealthy) {
            this.isHealthy = isHealthy;
            this.__explicitlySet__.add("isHealthy");
            return this;
        }

        public Builder errorCategory(ErrorCategory errorCategory) {
            this.errorCategory = errorCategory;
            this.__explicitlySet__.add("errorCategory");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder protocol(PingProbeProtocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder connection(Connection connection) {
            this.connection = connection;
            this.__explicitlySet__.add("connection");
            return this;
        }

        public Builder dns(DNS dns) {
            this.dns = dns;
            this.__explicitlySet__.add("dns");
            return this;
        }

        public Builder domainLookupStart(Double domainLookupStart) {
            this.domainLookupStart = domainLookupStart;
            this.__explicitlySet__.add("domainLookupStart");
            return this;
        }

        public Builder domainLookupEnd(Double domainLookupEnd) {
            this.domainLookupEnd = domainLookupEnd;
            this.__explicitlySet__.add("domainLookupEnd");
            return this;
        }

        public Builder latencyInMs(Double latencyInMs) {
            this.latencyInMs = latencyInMs;
            this.__explicitlySet__.add("latencyInMs");
            return this;
        }

        public Builder icmpCode(Integer icmpCode) {
            this.icmpCode = icmpCode;
            this.__explicitlySet__.add("icmpCode");
            return this;
        }

        public PingProbeResultSummary build() {
            PingProbeResultSummary model = new PingProbeResultSummary(this.key, this.probeConfigurationId, this.startTime, this.target, this.vantagePointName, this.isTimedOut, this.isHealthy, this.errorCategory, this.errorMessage, this.protocol, this.connection, this.dns, this.domainLookupStart, this.domainLookupEnd, this.latencyInMs, this.icmpCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PingProbeResultSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("probeConfigurationId")) {
                this.probeConfigurationId(model.getProbeConfigurationId());
            }
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("vantagePointName")) {
                this.vantagePointName(model.getVantagePointName());
            }
            if (model.wasPropertyExplicitlySet("isTimedOut")) {
                this.isTimedOut(model.getIsTimedOut());
            }
            if (model.wasPropertyExplicitlySet("isHealthy")) {
                this.isHealthy(model.getIsHealthy());
            }
            if (model.wasPropertyExplicitlySet("errorCategory")) {
                this.errorCategory(model.getErrorCategory());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("connection")) {
                this.connection(model.getConnection());
            }
            if (model.wasPropertyExplicitlySet("dns")) {
                this.dns(model.getDns());
            }
            if (model.wasPropertyExplicitlySet("domainLookupStart")) {
                this.domainLookupStart(model.getDomainLookupStart());
            }
            if (model.wasPropertyExplicitlySet("domainLookupEnd")) {
                this.domainLookupEnd(model.getDomainLookupEnd());
            }
            if (model.wasPropertyExplicitlySet("latencyInMs")) {
                this.latencyInMs(model.getLatencyInMs());
            }
            if (model.wasPropertyExplicitlySet("icmpCode")) {
                this.icmpCode(model.getIcmpCode());
            }
            return this;
        }
    }
}

