/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.healthchecks.model.DNS;
import com.oracle.bmc.healthchecks.model.HttpProbeProtocol;
import com.oracle.bmc.healthchecks.model.TcpConnection;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HttpProbeResultSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="probeConfigurationId")
    private final String probeConfigurationId;
    @JsonProperty(value="startTime")
    private final Double startTime;
    @JsonProperty(value="target")
    private final String target;
    @JsonProperty(value="vantagePointName")
    private final String vantagePointName;
    @JsonProperty(value="isTimedOut")
    private final Boolean isTimedOut;
    @JsonProperty(value="isHealthy")
    private final Boolean isHealthy;
    @JsonProperty(value="errorCategory")
    private final ErrorCategory errorCategory;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="protocol")
    private final HttpProbeProtocol protocol;
    @JsonProperty(value="connection")
    private final TcpConnection connection;
    @JsonProperty(value="dns")
    private final DNS dns;
    @JsonProperty(value="statusCode")
    private final Integer statusCode;
    @JsonProperty(value="domainLookupStart")
    private final Double domainLookupStart;
    @JsonProperty(value="domainLookupEnd")
    private final Double domainLookupEnd;
    @JsonProperty(value="connectStart")
    private final Double connectStart;
    @JsonProperty(value="secureConnectionStart")
    private final Double secureConnectionStart;
    @JsonProperty(value="connectEnd")
    private final Double connectEnd;
    @JsonProperty(value="fetchStart")
    private final Double fetchStart;
    @JsonProperty(value="requestStart")
    private final Double requestStart;
    @JsonProperty(value="responseStart")
    private final Double responseStart;
    @JsonProperty(value="responseEnd")
    private final Double responseEnd;
    @JsonProperty(value="duration")
    private final Double duration;
    @JsonProperty(value="encodedBodySize")
    private final Integer encodedBodySize;

    @Deprecated
    @ConstructorProperties(value={"key", "probeConfigurationId", "startTime", "target", "vantagePointName", "isTimedOut", "isHealthy", "errorCategory", "errorMessage", "protocol", "connection", "dns", "statusCode", "domainLookupStart", "domainLookupEnd", "connectStart", "secureConnectionStart", "connectEnd", "fetchStart", "requestStart", "responseStart", "responseEnd", "duration", "encodedBodySize"})
    public HttpProbeResultSummary(String key, String probeConfigurationId, Double startTime, String target, String vantagePointName, Boolean isTimedOut, Boolean isHealthy, ErrorCategory errorCategory, String errorMessage, HttpProbeProtocol protocol, TcpConnection connection, DNS dns, Integer statusCode, Double domainLookupStart, Double domainLookupEnd, Double connectStart, Double secureConnectionStart, Double connectEnd, Double fetchStart, Double requestStart, Double responseStart, Double responseEnd, Double duration, Integer encodedBodySize) {
        this.key = key;
        this.probeConfigurationId = probeConfigurationId;
        this.startTime = startTime;
        this.target = target;
        this.vantagePointName = vantagePointName;
        this.isTimedOut = isTimedOut;
        this.isHealthy = isHealthy;
        this.errorCategory = errorCategory;
        this.errorMessage = errorMessage;
        this.protocol = protocol;
        this.connection = connection;
        this.dns = dns;
        this.statusCode = statusCode;
        this.domainLookupStart = domainLookupStart;
        this.domainLookupEnd = domainLookupEnd;
        this.connectStart = connectStart;
        this.secureConnectionStart = secureConnectionStart;
        this.connectEnd = connectEnd;
        this.fetchStart = fetchStart;
        this.requestStart = requestStart;
        this.responseStart = responseStart;
        this.responseEnd = responseEnd;
        this.duration = duration;
        this.encodedBodySize = encodedBodySize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getProbeConfigurationId() {
        return this.probeConfigurationId;
    }

    public Double getStartTime() {
        return this.startTime;
    }

    public String getTarget() {
        return this.target;
    }

    public String getVantagePointName() {
        return this.vantagePointName;
    }

    public Boolean getIsTimedOut() {
        return this.isTimedOut;
    }

    public Boolean getIsHealthy() {
        return this.isHealthy;
    }

    public ErrorCategory getErrorCategory() {
        return this.errorCategory;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public HttpProbeProtocol getProtocol() {
        return this.protocol;
    }

    public TcpConnection getConnection() {
        return this.connection;
    }

    public DNS getDns() {
        return this.dns;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public Double getDomainLookupStart() {
        return this.domainLookupStart;
    }

    public Double getDomainLookupEnd() {
        return this.domainLookupEnd;
    }

    public Double getConnectStart() {
        return this.connectStart;
    }

    public Double getSecureConnectionStart() {
        return this.secureConnectionStart;
    }

    public Double getConnectEnd() {
        return this.connectEnd;
    }

    public Double getFetchStart() {
        return this.fetchStart;
    }

    public Double getRequestStart() {
        return this.requestStart;
    }

    public Double getResponseStart() {
        return this.responseStart;
    }

    public Double getResponseEnd() {
        return this.responseEnd;
    }

    public Double getDuration() {
        return this.duration;
    }

    public Integer getEncodedBodySize() {
        return this.encodedBodySize;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpProbeResultSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", probeConfigurationId=").append(String.valueOf(this.probeConfigurationId));
        sb.append(", startTime=").append(String.valueOf(this.startTime));
        sb.append(", target=").append(String.valueOf(this.target));
        sb.append(", vantagePointName=").append(String.valueOf(this.vantagePointName));
        sb.append(", isTimedOut=").append(String.valueOf(this.isTimedOut));
        sb.append(", isHealthy=").append(String.valueOf(this.isHealthy));
        sb.append(", errorCategory=").append(String.valueOf((Object)this.errorCategory));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", connection=").append(String.valueOf((Object)this.connection));
        sb.append(", dns=").append(String.valueOf((Object)this.dns));
        sb.append(", statusCode=").append(String.valueOf(this.statusCode));
        sb.append(", domainLookupStart=").append(String.valueOf(this.domainLookupStart));
        sb.append(", domainLookupEnd=").append(String.valueOf(this.domainLookupEnd));
        sb.append(", connectStart=").append(String.valueOf(this.connectStart));
        sb.append(", secureConnectionStart=").append(String.valueOf(this.secureConnectionStart));
        sb.append(", connectEnd=").append(String.valueOf(this.connectEnd));
        sb.append(", fetchStart=").append(String.valueOf(this.fetchStart));
        sb.append(", requestStart=").append(String.valueOf(this.requestStart));
        sb.append(", responseStart=").append(String.valueOf(this.responseStart));
        sb.append(", responseEnd=").append(String.valueOf(this.responseEnd));
        sb.append(", duration=").append(String.valueOf(this.duration));
        sb.append(", encodedBodySize=").append(String.valueOf(this.encodedBodySize));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpProbeResultSummary)) {
            return false;
        }
        HttpProbeResultSummary other = (HttpProbeResultSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.probeConfigurationId, other.probeConfigurationId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.target, other.target) && Objects.equals(this.vantagePointName, other.vantagePointName) && Objects.equals(this.isTimedOut, other.isTimedOut) && Objects.equals(this.isHealthy, other.isHealthy) && Objects.equals((Object)this.errorCategory, (Object)other.errorCategory) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals((Object)this.connection, (Object)other.connection) && Objects.equals((Object)this.dns, (Object)other.dns) && Objects.equals(this.statusCode, other.statusCode) && Objects.equals(this.domainLookupStart, other.domainLookupStart) && Objects.equals(this.domainLookupEnd, other.domainLookupEnd) && Objects.equals(this.connectStart, other.connectStart) && Objects.equals(this.secureConnectionStart, other.secureConnectionStart) && Objects.equals(this.connectEnd, other.connectEnd) && Objects.equals(this.fetchStart, other.fetchStart) && Objects.equals(this.requestStart, other.requestStart) && Objects.equals(this.responseStart, other.responseStart) && Objects.equals(this.responseEnd, other.responseEnd) && Objects.equals(this.duration, other.duration) && Objects.equals(this.encodedBodySize, other.encodedBodySize) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.probeConfigurationId == null ? 43 : this.probeConfigurationId.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.vantagePointName == null ? 43 : this.vantagePointName.hashCode());
        result = result * 59 + (this.isTimedOut == null ? 43 : this.isTimedOut.hashCode());
        result = result * 59 + (this.isHealthy == null ? 43 : this.isHealthy.hashCode());
        result = result * 59 + (this.errorCategory == null ? 43 : this.errorCategory.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.connection == null ? 43 : this.connection.hashCode());
        result = result * 59 + (this.dns == null ? 43 : this.dns.hashCode());
        result = result * 59 + (this.statusCode == null ? 43 : this.statusCode.hashCode());
        result = result * 59 + (this.domainLookupStart == null ? 43 : this.domainLookupStart.hashCode());
        result = result * 59 + (this.domainLookupEnd == null ? 43 : this.domainLookupEnd.hashCode());
        result = result * 59 + (this.connectStart == null ? 43 : this.connectStart.hashCode());
        result = result * 59 + (this.secureConnectionStart == null ? 43 : this.secureConnectionStart.hashCode());
        result = result * 59 + (this.connectEnd == null ? 43 : this.connectEnd.hashCode());
        result = result * 59 + (this.fetchStart == null ? 43 : this.fetchStart.hashCode());
        result = result * 59 + (this.requestStart == null ? 43 : this.requestStart.hashCode());
        result = result * 59 + (this.responseStart == null ? 43 : this.responseStart.hashCode());
        result = result * 59 + (this.responseEnd == null ? 43 : this.responseEnd.hashCode());
        result = result * 59 + (this.duration == null ? 43 : this.duration.hashCode());
        result = result * 59 + (this.encodedBodySize == null ? 43 : this.encodedBodySize.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ErrorCategory implements BmcEnum
    {
        None("NONE"),
        Dns("DNS"),
        Transport("TRANSPORT"),
        Network("NETWORK"),
        System("SYSTEM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ErrorCategory> map;

        private ErrorCategory(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ErrorCategory create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ErrorCategory', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ErrorCategory.class);
            map = new HashMap<String, ErrorCategory>();
            for (ErrorCategory v : ErrorCategory.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="probeConfigurationId")
        private String probeConfigurationId;
        @JsonProperty(value="startTime")
        private Double startTime;
        @JsonProperty(value="target")
        private String target;
        @JsonProperty(value="vantagePointName")
        private String vantagePointName;
        @JsonProperty(value="isTimedOut")
        private Boolean isTimedOut;
        @JsonProperty(value="isHealthy")
        private Boolean isHealthy;
        @JsonProperty(value="errorCategory")
        private ErrorCategory errorCategory;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="protocol")
        private HttpProbeProtocol protocol;
        @JsonProperty(value="connection")
        private TcpConnection connection;
        @JsonProperty(value="dns")
        private DNS dns;
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="domainLookupStart")
        private Double domainLookupStart;
        @JsonProperty(value="domainLookupEnd")
        private Double domainLookupEnd;
        @JsonProperty(value="connectStart")
        private Double connectStart;
        @JsonProperty(value="secureConnectionStart")
        private Double secureConnectionStart;
        @JsonProperty(value="connectEnd")
        private Double connectEnd;
        @JsonProperty(value="fetchStart")
        private Double fetchStart;
        @JsonProperty(value="requestStart")
        private Double requestStart;
        @JsonProperty(value="responseStart")
        private Double responseStart;
        @JsonProperty(value="responseEnd")
        private Double responseEnd;
        @JsonProperty(value="duration")
        private Double duration;
        @JsonProperty(value="encodedBodySize")
        private Integer encodedBodySize;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder probeConfigurationId(String probeConfigurationId) {
            this.probeConfigurationId = probeConfigurationId;
            this.__explicitlySet__.add("probeConfigurationId");
            return this;
        }

        public Builder startTime(Double startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder vantagePointName(String vantagePointName) {
            this.vantagePointName = vantagePointName;
            this.__explicitlySet__.add("vantagePointName");
            return this;
        }

        public Builder isTimedOut(Boolean isTimedOut) {
            this.isTimedOut = isTimedOut;
            this.__explicitlySet__.add("isTimedOut");
            return this;
        }

        public Builder isHealthy(Boolean isHealthy) {
            this.isHealthy = isHealthy;
            this.__explicitlySet__.add("isHealthy");
            return this;
        }

        public Builder errorCategory(ErrorCategory errorCategory) {
            this.errorCategory = errorCategory;
            this.__explicitlySet__.add("errorCategory");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder protocol(HttpProbeProtocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder connection(TcpConnection connection) {
            this.connection = connection;
            this.__explicitlySet__.add("connection");
            return this;
        }

        public Builder dns(DNS dns) {
            this.dns = dns;
            this.__explicitlySet__.add("dns");
            return this;
        }

        public Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            this.__explicitlySet__.add("statusCode");
            return this;
        }

        public Builder domainLookupStart(Double domainLookupStart) {
            this.domainLookupStart = domainLookupStart;
            this.__explicitlySet__.add("domainLookupStart");
            return this;
        }

        public Builder domainLookupEnd(Double domainLookupEnd) {
            this.domainLookupEnd = domainLookupEnd;
            this.__explicitlySet__.add("domainLookupEnd");
            return this;
        }

        public Builder connectStart(Double connectStart) {
            this.connectStart = connectStart;
            this.__explicitlySet__.add("connectStart");
            return this;
        }

        public Builder secureConnectionStart(Double secureConnectionStart) {
            this.secureConnectionStart = secureConnectionStart;
            this.__explicitlySet__.add("secureConnectionStart");
            return this;
        }

        public Builder connectEnd(Double connectEnd) {
            this.connectEnd = connectEnd;
            this.__explicitlySet__.add("connectEnd");
            return this;
        }

        public Builder fetchStart(Double fetchStart) {
            this.fetchStart = fetchStart;
            this.__explicitlySet__.add("fetchStart");
            return this;
        }

        public Builder requestStart(Double requestStart) {
            this.requestStart = requestStart;
            this.__explicitlySet__.add("requestStart");
            return this;
        }

        public Builder responseStart(Double responseStart) {
            this.responseStart = responseStart;
            this.__explicitlySet__.add("responseStart");
            return this;
        }

        public Builder responseEnd(Double responseEnd) {
            this.responseEnd = responseEnd;
            this.__explicitlySet__.add("responseEnd");
            return this;
        }

        public Builder duration(Double duration) {
            this.duration = duration;
            this.__explicitlySet__.add("duration");
            return this;
        }

        public Builder encodedBodySize(Integer encodedBodySize) {
            this.encodedBodySize = encodedBodySize;
            this.__explicitlySet__.add("encodedBodySize");
            return this;
        }

        public HttpProbeResultSummary build() {
            HttpProbeResultSummary model = new HttpProbeResultSummary(this.key, this.probeConfigurationId, this.startTime, this.target, this.vantagePointName, this.isTimedOut, this.isHealthy, this.errorCategory, this.errorMessage, this.protocol, this.connection, this.dns, this.statusCode, this.domainLookupStart, this.domainLookupEnd, this.connectStart, this.secureConnectionStart, this.connectEnd, this.fetchStart, this.requestStart, this.responseStart, this.responseEnd, this.duration, this.encodedBodySize);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HttpProbeResultSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("probeConfigurationId")) {
                this.probeConfigurationId(model.getProbeConfigurationId());
            }
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("vantagePointName")) {
                this.vantagePointName(model.getVantagePointName());
            }
            if (model.wasPropertyExplicitlySet("isTimedOut")) {
                this.isTimedOut(model.getIsTimedOut());
            }
            if (model.wasPropertyExplicitlySet("isHealthy")) {
                this.isHealthy(model.getIsHealthy());
            }
            if (model.wasPropertyExplicitlySet("errorCategory")) {
                this.errorCategory(model.getErrorCategory());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("connection")) {
                this.connection(model.getConnection());
            }
            if (model.wasPropertyExplicitlySet("dns")) {
                this.dns(model.getDns());
            }
            if (model.wasPropertyExplicitlySet("statusCode")) {
                this.statusCode(model.getStatusCode());
            }
            if (model.wasPropertyExplicitlySet("domainLookupStart")) {
                this.domainLookupStart(model.getDomainLookupStart());
            }
            if (model.wasPropertyExplicitlySet("domainLookupEnd")) {
                this.domainLookupEnd(model.getDomainLookupEnd());
            }
            if (model.wasPropertyExplicitlySet("connectStart")) {
                this.connectStart(model.getConnectStart());
            }
            if (model.wasPropertyExplicitlySet("secureConnectionStart")) {
                this.secureConnectionStart(model.getSecureConnectionStart());
            }
            if (model.wasPropertyExplicitlySet("connectEnd")) {
                this.connectEnd(model.getConnectEnd());
            }
            if (model.wasPropertyExplicitlySet("fetchStart")) {
                this.fetchStart(model.getFetchStart());
            }
            if (model.wasPropertyExplicitlySet("requestStart")) {
                this.requestStart(model.getRequestStart());
            }
            if (model.wasPropertyExplicitlySet("responseStart")) {
                this.responseStart(model.getResponseStart());
            }
            if (model.wasPropertyExplicitlySet("responseEnd")) {
                this.responseEnd(model.getResponseEnd());
            }
            if (model.wasPropertyExplicitlySet("duration")) {
                this.duration(model.getDuration());
            }
            if (model.wasPropertyExplicitlySet("encodedBodySize")) {
                this.encodedBodySize(model.getEncodedBodySize());
            }
            return this;
        }
    }
}

