/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.healthchecks.model.PingProbeProtocol;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PingProbe
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="resultsUrl")
    private final String resultsUrl;
    @JsonProperty(value="homeRegion")
    private final String homeRegion;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targets")
    private final List<String> targets;
    @JsonProperty(value="vantagePointNames")
    private final List<String> vantagePointNames;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="timeoutInSeconds")
    private final Integer timeoutInSeconds;
    @JsonProperty(value="protocol")
    private final PingProbeProtocol protocol;

    @Deprecated
    @ConstructorProperties(value={"id", "resultsUrl", "homeRegion", "timeCreated", "compartmentId", "targets", "vantagePointNames", "port", "timeoutInSeconds", "protocol"})
    public PingProbe(String id, String resultsUrl, String homeRegion, Date timeCreated, String compartmentId, List<String> targets, List<String> vantagePointNames, Integer port, Integer timeoutInSeconds, PingProbeProtocol protocol) {
        this.id = id;
        this.resultsUrl = resultsUrl;
        this.homeRegion = homeRegion;
        this.timeCreated = timeCreated;
        this.compartmentId = compartmentId;
        this.targets = targets;
        this.vantagePointNames = vantagePointNames;
        this.port = port;
        this.timeoutInSeconds = timeoutInSeconds;
        this.protocol = protocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getResultsUrl() {
        return this.resultsUrl;
    }

    public String getHomeRegion() {
        return this.homeRegion;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public List<String> getVantagePointNames() {
        return this.vantagePointNames;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public PingProbeProtocol getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PingProbe(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", resultsUrl=").append(String.valueOf(this.resultsUrl));
        sb.append(", homeRegion=").append(String.valueOf(this.homeRegion));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targets=").append(String.valueOf(this.targets));
        sb.append(", vantagePointNames=").append(String.valueOf(this.vantagePointNames));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", timeoutInSeconds=").append(String.valueOf(this.timeoutInSeconds));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PingProbe)) {
            return false;
        }
        PingProbe other = (PingProbe)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.resultsUrl, other.resultsUrl) && Objects.equals(this.homeRegion, other.homeRegion) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targets, other.targets) && Objects.equals(this.vantagePointNames, other.vantagePointNames) && Objects.equals(this.port, other.port) && Objects.equals(this.timeoutInSeconds, other.timeoutInSeconds) && Objects.equals((Object)this.protocol, (Object)other.protocol) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.resultsUrl == null ? 43 : this.resultsUrl.hashCode());
        result = result * 59 + (this.homeRegion == null ? 43 : this.homeRegion.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targets == null ? 43 : this.targets.hashCode());
        result = result * 59 + (this.vantagePointNames == null ? 43 : this.vantagePointNames.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.timeoutInSeconds == null ? 43 : this.timeoutInSeconds.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="resultsUrl")
        private String resultsUrl;
        @JsonProperty(value="homeRegion")
        private String homeRegion;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targets")
        private List<String> targets;
        @JsonProperty(value="vantagePointNames")
        private List<String> vantagePointNames;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="timeoutInSeconds")
        private Integer timeoutInSeconds;
        @JsonProperty(value="protocol")
        private PingProbeProtocol protocol;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder resultsUrl(String resultsUrl) {
            this.resultsUrl = resultsUrl;
            this.__explicitlySet__.add("resultsUrl");
            return this;
        }

        public Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            this.__explicitlySet__.add("homeRegion");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targets(List<String> targets) {
            this.targets = targets;
            this.__explicitlySet__.add("targets");
            return this;
        }

        public Builder vantagePointNames(List<String> vantagePointNames) {
            this.vantagePointNames = vantagePointNames;
            this.__explicitlySet__.add("vantagePointNames");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            this.__explicitlySet__.add("timeoutInSeconds");
            return this;
        }

        public Builder protocol(PingProbeProtocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public PingProbe build() {
            PingProbe model = new PingProbe(this.id, this.resultsUrl, this.homeRegion, this.timeCreated, this.compartmentId, this.targets, this.vantagePointNames, this.port, this.timeoutInSeconds, this.protocol);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PingProbe model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("resultsUrl")) {
                this.resultsUrl(model.getResultsUrl());
            }
            if (model.wasPropertyExplicitlySet("homeRegion")) {
                this.homeRegion(model.getHomeRegion());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targets")) {
                this.targets(model.getTargets());
            }
            if (model.wasPropertyExplicitlySet("vantagePointNames")) {
                this.vantagePointNames(model.getVantagePointNames());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("timeoutInSeconds")) {
                this.timeoutInSeconds(model.getTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            return this;
        }
    }
}

