/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TcpConnection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="address")
    private final String address;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="connectDuration")
    private final Double connectDuration;
    @JsonProperty(value="secureConnectDuration")
    private final Double secureConnectDuration;

    @Deprecated
    @ConstructorProperties(value={"address", "port", "connectDuration", "secureConnectDuration"})
    public TcpConnection(String address, Integer port, Double connectDuration, Double secureConnectDuration) {
        this.address = address;
        this.port = port;
        this.connectDuration = connectDuration;
        this.secureConnectDuration = secureConnectDuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getPort() {
        return this.port;
    }

    public Double getConnectDuration() {
        return this.connectDuration;
    }

    public Double getSecureConnectDuration() {
        return this.secureConnectDuration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TcpConnection(");
        sb.append("super=").append(super.toString());
        sb.append("address=").append(String.valueOf(this.address));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", connectDuration=").append(String.valueOf(this.connectDuration));
        sb.append(", secureConnectDuration=").append(String.valueOf(this.secureConnectDuration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcpConnection)) {
            return false;
        }
        TcpConnection other = (TcpConnection)((Object)o);
        return Objects.equals(this.address, other.address) && Objects.equals(this.port, other.port) && Objects.equals(this.connectDuration, other.connectDuration) && Objects.equals(this.secureConnectDuration, other.secureConnectDuration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.address == null ? 43 : this.address.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.connectDuration == null ? 43 : this.connectDuration.hashCode());
        result = result * 59 + (this.secureConnectDuration == null ? 43 : this.secureConnectDuration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="address")
        private String address;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="connectDuration")
        private Double connectDuration;
        @JsonProperty(value="secureConnectDuration")
        private Double secureConnectDuration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder address(String address) {
            this.address = address;
            this.__explicitlySet__.add("address");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder connectDuration(Double connectDuration) {
            this.connectDuration = connectDuration;
            this.__explicitlySet__.add("connectDuration");
            return this;
        }

        public Builder secureConnectDuration(Double secureConnectDuration) {
            this.secureConnectDuration = secureConnectDuration;
            this.__explicitlySet__.add("secureConnectDuration");
            return this;
        }

        public TcpConnection build() {
            TcpConnection model = new TcpConnection(this.address, this.port, this.connectDuration, this.secureConnectDuration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TcpConnection model) {
            if (model.wasPropertyExplicitlySet("address")) {
                this.address(model.getAddress());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("connectDuration")) {
                this.connectDuration(model.getConnectDuration());
            }
            if (model.wasPropertyExplicitlySet("secureConnectDuration")) {
                this.secureConnectDuration(model.getSecureConnectDuration());
            }
            return this;
        }
    }
}

