/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListPingProbeResultsRequest
extends BmcRequest<Void> {
    private String probeConfigurationId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private Double startTimeGreaterThanOrEqualTo;
    private Double startTimeLessThanOrEqualTo;
    private SortOrder sortOrder;
    private String target;

    public String getProbeConfigurationId() {
        return this.probeConfigurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Double getStartTimeGreaterThanOrEqualTo() {
        return this.startTimeGreaterThanOrEqualTo;
    }

    public Double getStartTimeLessThanOrEqualTo() {
        return this.startTimeLessThanOrEqualTo;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getTarget() {
        return this.target;
    }

    public Builder toBuilder() {
        return new Builder().probeConfigurationId(this.probeConfigurationId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).startTimeGreaterThanOrEqualTo(this.startTimeGreaterThanOrEqualTo).startTimeLessThanOrEqualTo(this.startTimeLessThanOrEqualTo).sortOrder(this.sortOrder).target(this.target);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",probeConfigurationId=").append(String.valueOf(this.probeConfigurationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",startTimeGreaterThanOrEqualTo=").append(String.valueOf(this.startTimeGreaterThanOrEqualTo));
        sb.append(",startTimeLessThanOrEqualTo=").append(String.valueOf(this.startTimeLessThanOrEqualTo));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",target=").append(String.valueOf(this.target));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPingProbeResultsRequest)) {
            return false;
        }
        ListPingProbeResultsRequest other = (ListPingProbeResultsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.probeConfigurationId, other.probeConfigurationId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.startTimeGreaterThanOrEqualTo, other.startTimeGreaterThanOrEqualTo) && Objects.equals(this.startTimeLessThanOrEqualTo, other.startTimeLessThanOrEqualTo) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.target, other.target);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.probeConfigurationId == null ? 43 : this.probeConfigurationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.startTimeGreaterThanOrEqualTo == null ? 43 : this.startTimeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.startTimeLessThanOrEqualTo == null ? 43 : this.startTimeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPingProbeResultsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String probeConfigurationId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private Double startTimeGreaterThanOrEqualTo = null;
        private Double startTimeLessThanOrEqualTo = null;
        private SortOrder sortOrder = null;
        private String target = null;

        public Builder probeConfigurationId(String probeConfigurationId) {
            this.probeConfigurationId = probeConfigurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder startTimeGreaterThanOrEqualTo(Double startTimeGreaterThanOrEqualTo) {
            this.startTimeGreaterThanOrEqualTo = startTimeGreaterThanOrEqualTo;
            return this;
        }

        public Builder startTimeLessThanOrEqualTo(Double startTimeLessThanOrEqualTo) {
            this.startTimeLessThanOrEqualTo = startTimeLessThanOrEqualTo;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPingProbeResultsRequest o) {
            this.probeConfigurationId(o.getProbeConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.startTimeGreaterThanOrEqualTo(o.getStartTimeGreaterThanOrEqualTo());
            this.startTimeLessThanOrEqualTo(o.getStartTimeLessThanOrEqualTo());
            this.sortOrder(o.getSortOrder());
            this.target(o.getTarget());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPingProbeResultsRequest build() {
            ListPingProbeResultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPingProbeResultsRequest buildWithoutInvocationCallback() {
            ListPingProbeResultsRequest request = new ListPingProbeResultsRequest();
            request.probeConfigurationId = this.probeConfigurationId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.startTimeGreaterThanOrEqualTo = this.startTimeGreaterThanOrEqualTo;
            request.startTimeLessThanOrEqualTo = this.startTimeLessThanOrEqualTo;
            request.sortOrder = this.sortOrder;
            request.target = this.target;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

