/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.healthchecks.model.UpdateHttpMonitorDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateHttpMonitorRequest
extends BmcRequest<UpdateHttpMonitorDetails> {
    private String monitorId;
    private UpdateHttpMonitorDetails updateHttpMonitorDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getMonitorId() {
        return this.monitorId;
    }

    public UpdateHttpMonitorDetails getUpdateHttpMonitorDetails() {
        return this.updateHttpMonitorDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateHttpMonitorDetails getBody$() {
        return this.updateHttpMonitorDetails;
    }

    public Builder toBuilder() {
        return new Builder().monitorId(this.monitorId).updateHttpMonitorDetails(this.updateHttpMonitorDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",monitorId=").append(String.valueOf(this.monitorId));
        sb.append(",updateHttpMonitorDetails=").append(String.valueOf((Object)this.updateHttpMonitorDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateHttpMonitorRequest)) {
            return false;
        }
        UpdateHttpMonitorRequest other = (UpdateHttpMonitorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.monitorId, other.monitorId) && Objects.equals((Object)this.updateHttpMonitorDetails, (Object)other.updateHttpMonitorDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.monitorId == null ? 43 : this.monitorId.hashCode());
        result = result * 59 + (this.updateHttpMonitorDetails == null ? 43 : this.updateHttpMonitorDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateHttpMonitorRequest, UpdateHttpMonitorDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String monitorId = null;
        private UpdateHttpMonitorDetails updateHttpMonitorDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public Builder updateHttpMonitorDetails(UpdateHttpMonitorDetails updateHttpMonitorDetails) {
            this.updateHttpMonitorDetails = updateHttpMonitorDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateHttpMonitorRequest o) {
            this.monitorId(o.getMonitorId());
            this.updateHttpMonitorDetails(o.getUpdateHttpMonitorDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateHttpMonitorRequest build() {
            UpdateHttpMonitorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateHttpMonitorDetails body) {
            this.updateHttpMonitorDetails(body);
            return this;
        }

        public UpdateHttpMonitorRequest buildWithoutInvocationCallback() {
            UpdateHttpMonitorRequest request = new UpdateHttpMonitorRequest();
            request.monitorId = this.monitorId;
            request.updateHttpMonitorDetails = this.updateHttpMonitorDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

