/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.requests.DeleteIdpGroupMappingRequest;
import com.oracle.bmc.identity.responses.DeleteIdpGroupMappingResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteIdpGroupMappingConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteIdpGroupMappingConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteIdpGroupMappingRequest interceptRequest(DeleteIdpGroupMappingRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteIdpGroupMappingRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMappingId(), (String)"mappingId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("identityProviders").path(HttpUtils.encodePathSegment((String)request.getIdentityProviderId())).path("groupMappings").path(HttpUtils.encodePathSegment((String)request.getMappingId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, DeleteIdpGroupMappingResponse> fromResponse() {
        Function<Response, DeleteIdpGroupMappingResponse> transformer = new Function<Response, DeleteIdpGroupMappingResponse>(){

            public DeleteIdpGroupMappingResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for DeleteIdpGroupMappingResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteIdpGroupMappingResponse.Builder builder = DeleteIdpGroupMappingResponse.builder();
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                DeleteIdpGroupMappingResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

