/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.identity.model.CreateSaml2IdentityProviderDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="protocol", defaultImpl=CreateIdentityProviderDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CreateSaml2IdentityProviderDetails.class, name="SAML2")})
@JsonFilter(value="explicitlySetFilter")
public class CreateIdentityProviderDetails {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="productType")
    private final ProductType productType;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateIdentityProviderDetails)) {
            return false;
        }
        CreateIdentityProviderDetails other = (CreateIdentityProviderDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ProductType this$productType = this.getProductType();
        ProductType other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !((Object)((Object)this$productType)).equals((Object)other$productType)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        return !(this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateIdentityProviderDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ProductType $productType = this.getProductType();
        result = result * 59 + ($productType == null ? 43 : ((Object)((Object)$productType)).hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        return result;
    }

    public String toString() {
        return "CreateIdentityProviderDetails(compartmentId=" + this.getCompartmentId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", productType=" + (Object)((Object)this.getProductType()) + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ")";
    }

    @ConstructorProperties(value={"compartmentId", "name", "description", "productType", "freeformTags", "definedTags"})
    @Deprecated
    protected CreateIdentityProviderDetails(String compartmentId, String name, String description, ProductType productType, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.name = name;
        this.description = description;
        this.productType = productType;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static enum Protocol {
        Saml2("SAML2"),
        Adfs("ADFS");

        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid Protocol: " + key);
        }

        static {
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProductType {
        Idcs("IDCS"),
        Adfs("ADFS");

        private final String value;
        private static Map<String, ProductType> map;

        private ProductType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProductType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid ProductType: " + key);
        }

        static {
            map = new HashMap<String, ProductType>();
            for (ProductType v : ProductType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

