/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AssembleEffectiveTagSetRequest
extends BmcRequest {
    private String compartmentId;
    private TagDefaultSummary.LifecycleState lifecycleState;

    @ConstructorProperties(value={"compartmentId", "lifecycleState"})
    AssembleEffectiveTagSetRequest(String compartmentId, TagDefaultSummary.LifecycleState lifecycleState) {
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public TagDefaultSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder {
        private String compartmentId;
        private TagDefaultSummary.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AssembleEffectiveTagSetRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AssembleEffectiveTagSetRequest build() {
            AssembleEffectiveTagSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder lifecycleState(TagDefaultSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public AssembleEffectiveTagSetRequest buildWithoutInvocationCallback() {
            return new AssembleEffectiveTagSetRequest(this.compartmentId, this.lifecycleState);
        }

        public String toString() {
            return "AssembleEffectiveTagSetRequest.Builder(compartmentId=" + this.compartmentId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

