/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.CreateIdentityProviderDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateIdentityProviderRequest
extends BmcRequest {
    private CreateIdentityProviderDetails createIdentityProviderDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createIdentityProviderDetails", "opcRetryToken"})
    CreateIdentityProviderRequest(CreateIdentityProviderDetails createIdentityProviderDetails, String opcRetryToken) {
        this.createIdentityProviderDetails = createIdentityProviderDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateIdentityProviderDetails getCreateIdentityProviderDetails() {
        return this.createIdentityProviderDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateIdentityProviderDetails createIdentityProviderDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateIdentityProviderRequest o) {
            this.createIdentityProviderDetails(o.getCreateIdentityProviderDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateIdentityProviderRequest build() {
            CreateIdentityProviderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createIdentityProviderDetails(CreateIdentityProviderDetails createIdentityProviderDetails) {
            this.createIdentityProviderDetails = createIdentityProviderDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateIdentityProviderRequest buildWithoutInvocationCallback() {
            return new CreateIdentityProviderRequest(this.createIdentityProviderDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateIdentityProviderRequest.Builder(createIdentityProviderDetails=" + this.createIdentityProviderDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

