/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.CreatePolicyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreatePolicyRequest
extends BmcRequest {
    private CreatePolicyDetails createPolicyDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createPolicyDetails", "opcRetryToken"})
    CreatePolicyRequest(CreatePolicyDetails createPolicyDetails, String opcRetryToken) {
        this.createPolicyDetails = createPolicyDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreatePolicyDetails getCreatePolicyDetails() {
        return this.createPolicyDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreatePolicyDetails createPolicyDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePolicyRequest o) {
            this.createPolicyDetails(o.getCreatePolicyDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePolicyRequest build() {
            CreatePolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createPolicyDetails(CreatePolicyDetails createPolicyDetails) {
            this.createPolicyDetails = createPolicyDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreatePolicyRequest buildWithoutInvocationCallback() {
            return new CreatePolicyRequest(this.createPolicyDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreatePolicyRequest.Builder(createPolicyDetails=" + this.createPolicyDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

