/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteIdpGroupMappingRequest
extends BmcRequest {
    private String identityProviderId;
    private String mappingId;
    private String ifMatch;

    @ConstructorProperties(value={"identityProviderId", "mappingId", "ifMatch"})
    DeleteIdpGroupMappingRequest(String identityProviderId, String mappingId, String ifMatch) {
        this.identityProviderId = identityProviderId;
        this.mappingId = mappingId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getMappingId() {
        return this.mappingId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String identityProviderId;
        private String mappingId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteIdpGroupMappingRequest o) {
            this.identityProviderId(o.getIdentityProviderId());
            this.mappingId(o.getMappingId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteIdpGroupMappingRequest build() {
            DeleteIdpGroupMappingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder mappingId(String mappingId) {
            this.mappingId = mappingId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteIdpGroupMappingRequest buildWithoutInvocationCallback() {
            return new DeleteIdpGroupMappingRequest(this.identityProviderId, this.mappingId, this.ifMatch);
        }

        public String toString() {
            return "DeleteIdpGroupMappingRequest.Builder(identityProviderId=" + this.identityProviderId + ", mappingId=" + this.mappingId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

