/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteSmtpCredentialRequest
extends BmcRequest {
    private String userId;
    private String smtpCredentialId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "smtpCredentialId", "ifMatch"})
    DeleteSmtpCredentialRequest(String userId, String smtpCredentialId, String ifMatch) {
        this.userId = userId;
        this.smtpCredentialId = smtpCredentialId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSmtpCredentialId() {
        return this.smtpCredentialId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private String smtpCredentialId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSmtpCredentialRequest o) {
            this.userId(o.getUserId());
            this.smtpCredentialId(o.getSmtpCredentialId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSmtpCredentialRequest build() {
            DeleteSmtpCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder smtpCredentialId(String smtpCredentialId) {
            this.smtpCredentialId = smtpCredentialId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteSmtpCredentialRequest buildWithoutInvocationCallback() {
            return new DeleteSmtpCredentialRequest(this.userId, this.smtpCredentialId, this.ifMatch);
        }

        public String toString() {
            return "DeleteSmtpCredentialRequest.Builder(userId=" + this.userId + ", smtpCredentialId=" + this.smtpCredentialId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

