/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDynamicGroupRequest
extends BmcRequest {
    private String dynamicGroupId;

    @ConstructorProperties(value={"dynamicGroupId"})
    GetDynamicGroupRequest(String dynamicGroupId) {
        this.dynamicGroupId = dynamicGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDynamicGroupId() {
        return this.dynamicGroupId;
    }

    public static class Builder {
        private String dynamicGroupId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDynamicGroupRequest o) {
            this.dynamicGroupId(o.getDynamicGroupId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDynamicGroupRequest build() {
            GetDynamicGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dynamicGroupId(String dynamicGroupId) {
            this.dynamicGroupId = dynamicGroupId;
            return this;
        }

        public GetDynamicGroupRequest buildWithoutInvocationCallback() {
            return new GetDynamicGroupRequest(this.dynamicGroupId);
        }

        public String toString() {
            return "GetDynamicGroupRequest.Builder(dynamicGroupId=" + this.dynamicGroupId + ")";
        }
    }
}

