/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTagRequest
extends BmcRequest {
    private String tagNamespaceId;
    private String tagName;

    @ConstructorProperties(value={"tagNamespaceId", "tagName"})
    GetTagRequest(String tagNamespaceId, String tagName) {
        this.tagNamespaceId = tagNamespaceId;
        this.tagName = tagName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public static class Builder {
        private String tagNamespaceId;
        private String tagName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTagRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.tagName(o.getTagName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTagRequest build() {
            GetTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder tagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        public GetTagRequest buildWithoutInvocationCallback() {
            return new GetTagRequest(this.tagNamespaceId, this.tagName);
        }

        public String toString() {
            return "GetTagRequest.Builder(tagNamespaceId=" + this.tagNamespaceId + ", tagName=" + this.tagName + ")";
        }
    }
}

