/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTaggingWorkRequestRequest
extends BmcRequest {
    private String workRequestId;

    @ConstructorProperties(value={"workRequestId"})
    GetTaggingWorkRequestRequest(String workRequestId) {
        this.workRequestId = workRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public static class Builder {
        private String workRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTaggingWorkRequestRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTaggingWorkRequestRequest build() {
            GetTaggingWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public GetTaggingWorkRequestRequest buildWithoutInvocationCallback() {
            return new GetTaggingWorkRequestRequest(this.workRequestId);
        }

        public String toString() {
            return "GetTaggingWorkRequestRequest.Builder(workRequestId=" + this.workRequestId + ")";
        }
    }
}

