/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTaggingWorkRequestErrorsRequest
extends BmcRequest {
    private String workRequestId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"workRequestId", "page", "limit"})
    ListTaggingWorkRequestErrorsRequest(String workRequestId, String page, Integer limit) {
        this.workRequestId = workRequestId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder {
        private String workRequestId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTaggingWorkRequestErrorsRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTaggingWorkRequestErrorsRequest build() {
            ListTaggingWorkRequestErrorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListTaggingWorkRequestErrorsRequest buildWithoutInvocationCallback() {
            return new ListTaggingWorkRequestErrorsRequest(this.workRequestId, this.page, this.limit);
        }

        public String toString() {
            return "ListTaggingWorkRequestErrorsRequest.Builder(workRequestId=" + this.workRequestId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

