/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RemoveUserFromGroupRequest
extends BmcRequest {
    private String userGroupMembershipId;
    private String ifMatch;

    @ConstructorProperties(value={"userGroupMembershipId", "ifMatch"})
    RemoveUserFromGroupRequest(String userGroupMembershipId, String ifMatch) {
        this.userGroupMembershipId = userGroupMembershipId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserGroupMembershipId() {
        return this.userGroupMembershipId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userGroupMembershipId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveUserFromGroupRequest o) {
            this.userGroupMembershipId(o.getUserGroupMembershipId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveUserFromGroupRequest build() {
            RemoveUserFromGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userGroupMembershipId(String userGroupMembershipId) {
            this.userGroupMembershipId = userGroupMembershipId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public RemoveUserFromGroupRequest buildWithoutInvocationCallback() {
            return new RemoveUserFromGroupRequest(this.userGroupMembershipId, this.ifMatch);
        }

        public String toString() {
            return "RemoveUserFromGroupRequest.Builder(userGroupMembershipId=" + this.userGroupMembershipId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

