/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateCustomerSecretKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateCustomerSecretKeyRequest
extends BmcRequest {
    private String userId;
    private String customerSecretKeyId;
    private UpdateCustomerSecretKeyDetails updateCustomerSecretKeyDetails;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "customerSecretKeyId", "updateCustomerSecretKeyDetails", "ifMatch"})
    UpdateCustomerSecretKeyRequest(String userId, String customerSecretKeyId, UpdateCustomerSecretKeyDetails updateCustomerSecretKeyDetails, String ifMatch) {
        this.userId = userId;
        this.customerSecretKeyId = customerSecretKeyId;
        this.updateCustomerSecretKeyDetails = updateCustomerSecretKeyDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCustomerSecretKeyId() {
        return this.customerSecretKeyId;
    }

    public UpdateCustomerSecretKeyDetails getUpdateCustomerSecretKeyDetails() {
        return this.updateCustomerSecretKeyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private String customerSecretKeyId;
        private UpdateCustomerSecretKeyDetails updateCustomerSecretKeyDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCustomerSecretKeyRequest o) {
            this.userId(o.getUserId());
            this.customerSecretKeyId(o.getCustomerSecretKeyId());
            this.updateCustomerSecretKeyDetails(o.getUpdateCustomerSecretKeyDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCustomerSecretKeyRequest build() {
            UpdateCustomerSecretKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder customerSecretKeyId(String customerSecretKeyId) {
            this.customerSecretKeyId = customerSecretKeyId;
            return this;
        }

        public Builder updateCustomerSecretKeyDetails(UpdateCustomerSecretKeyDetails updateCustomerSecretKeyDetails) {
            this.updateCustomerSecretKeyDetails = updateCustomerSecretKeyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateCustomerSecretKeyRequest buildWithoutInvocationCallback() {
            return new UpdateCustomerSecretKeyRequest(this.userId, this.customerSecretKeyId, this.updateCustomerSecretKeyDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateCustomerSecretKeyRequest.Builder(userId=" + this.userId + ", customerSecretKeyId=" + this.customerSecretKeyId + ", updateCustomerSecretKeyDetails=" + this.updateCustomerSecretKeyDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

