/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateGroupDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateGroupRequest
extends BmcRequest {
    private String groupId;
    private UpdateGroupDetails updateGroupDetails;
    private String ifMatch;

    @ConstructorProperties(value={"groupId", "updateGroupDetails", "ifMatch"})
    UpdateGroupRequest(String groupId, UpdateGroupDetails updateGroupDetails, String ifMatch) {
        this.groupId = groupId;
        this.updateGroupDetails = updateGroupDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public UpdateGroupDetails getUpdateGroupDetails() {
        return this.updateGroupDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String groupId;
        private UpdateGroupDetails updateGroupDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateGroupRequest o) {
            this.groupId(o.getGroupId());
            this.updateGroupDetails(o.getUpdateGroupDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateGroupRequest build() {
            UpdateGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder updateGroupDetails(UpdateGroupDetails updateGroupDetails) {
            this.updateGroupDetails = updateGroupDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateGroupRequest buildWithoutInvocationCallback() {
            return new UpdateGroupRequest(this.groupId, this.updateGroupDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateGroupRequest.Builder(groupId=" + this.groupId + ", updateGroupDetails=" + this.updateGroupDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

