/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateStateDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateUserStateRequest
extends BmcRequest {
    private String userId;
    private UpdateStateDetails updateStateDetails;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "updateStateDetails", "ifMatch"})
    UpdateUserStateRequest(String userId, UpdateStateDetails updateStateDetails, String ifMatch) {
        this.userId = userId;
        this.updateStateDetails = updateStateDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public UpdateStateDetails getUpdateStateDetails() {
        return this.updateStateDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private UpdateStateDetails updateStateDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateUserStateRequest o) {
            this.userId(o.getUserId());
            this.updateStateDetails(o.getUpdateStateDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateUserStateRequest build() {
            UpdateUserStateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder updateStateDetails(UpdateStateDetails updateStateDetails) {
            this.updateStateDetails = updateStateDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateUserStateRequest buildWithoutInvocationCallback() {
            return new UpdateUserStateRequest(this.userId, this.updateStateDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateUserStateRequest.Builder(userId=" + this.userId + ", updateStateDetails=" + this.updateStateDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

