/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.SmtpCredential;
import java.beans.ConstructorProperties;

public class CreateSmtpCredentialResponse {
    private String opcRequestId;
    private String etag;
    private SmtpCredential smtpCredential;

    @ConstructorProperties(value={"opcRequestId", "etag", "smtpCredential"})
    CreateSmtpCredentialResponse(String opcRequestId, String etag, SmtpCredential smtpCredential) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.smtpCredential = smtpCredential;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public SmtpCredential getSmtpCredential() {
        return this.smtpCredential;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private SmtpCredential smtpCredential;

        public Builder copy(CreateSmtpCredentialResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.smtpCredential(o.getSmtpCredential());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder smtpCredential(SmtpCredential smtpCredential) {
            this.smtpCredential = smtpCredential;
            return this;
        }

        public CreateSmtpCredentialResponse build() {
            return new CreateSmtpCredentialResponse(this.opcRequestId, this.etag, this.smtpCredential);
        }

        public String toString() {
            return "CreateSmtpCredentialResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", smtpCredential=" + this.smtpCredential + ")";
        }
    }
}

