/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.TagDefault;
import java.beans.ConstructorProperties;

public class CreateTagDefaultResponse {
    private String opcRequestId;
    private String etag;
    private TagDefault tagDefault;

    @ConstructorProperties(value={"opcRequestId", "etag", "tagDefault"})
    CreateTagDefaultResponse(String opcRequestId, String etag, TagDefault tagDefault) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.tagDefault = tagDefault;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public TagDefault getTagDefault() {
        return this.tagDefault;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private TagDefault tagDefault;

        public Builder copy(CreateTagDefaultResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.tagDefault(o.getTagDefault());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder tagDefault(TagDefault tagDefault) {
            this.tagDefault = tagDefault;
            return this;
        }

        public CreateTagDefaultResponse build() {
            return new CreateTagDefaultResponse(this.opcRequestId, this.etag, this.tagDefault);
        }

        public String toString() {
            return "CreateTagDefaultResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", tagDefault=" + this.tagDefault + ")";
        }
    }
}

