/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.TagNamespace;
import java.beans.ConstructorProperties;

public class CreateTagNamespaceResponse {
    private String opcRequestId;
    private TagNamespace tagNamespace;

    @ConstructorProperties(value={"opcRequestId", "tagNamespace"})
    CreateTagNamespaceResponse(String opcRequestId, TagNamespace tagNamespace) {
        this.opcRequestId = opcRequestId;
        this.tagNamespace = tagNamespace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public TagNamespace getTagNamespace() {
        return this.tagNamespace;
    }

    public static class Builder {
        private String opcRequestId;
        private TagNamespace tagNamespace;

        public Builder copy(CreateTagNamespaceResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.tagNamespace(o.getTagNamespace());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder tagNamespace(TagNamespace tagNamespace) {
            this.tagNamespace = tagNamespace;
            return this;
        }

        public CreateTagNamespaceResponse build() {
            return new CreateTagNamespaceResponse(this.opcRequestId, this.tagNamespace);
        }

        public String toString() {
            return "CreateTagNamespaceResponse.Builder(opcRequestId=" + this.opcRequestId + ", tagNamespace=" + this.tagNamespace + ")";
        }
    }
}

