/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.UserGroupMembership;
import java.beans.ConstructorProperties;

public class GetUserGroupMembershipResponse {
    private String opcRequestId;
    private String etag;
    private UserGroupMembership userGroupMembership;

    @ConstructorProperties(value={"opcRequestId", "etag", "userGroupMembership"})
    GetUserGroupMembershipResponse(String opcRequestId, String etag, UserGroupMembership userGroupMembership) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.userGroupMembership = userGroupMembership;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public UserGroupMembership getUserGroupMembership() {
        return this.userGroupMembership;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private UserGroupMembership userGroupMembership;

        public Builder copy(GetUserGroupMembershipResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.userGroupMembership(o.getUserGroupMembership());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder userGroupMembership(UserGroupMembership userGroupMembership) {
            this.userGroupMembership = userGroupMembership;
            return this;
        }

        public GetUserGroupMembershipResponse build() {
            return new GetUserGroupMembershipResponse(this.opcRequestId, this.etag, this.userGroupMembership);
        }

        public String toString() {
            return "GetUserGroupMembershipResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", userGroupMembership=" + this.userGroupMembership + ")";
        }
    }
}

