/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.Region;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListRegionsResponse {
    private String opcRequestId;
    private List<Region> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListRegionsResponse(String opcRequestId, List<Region> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Region> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<Region> items;

        public Builder copy(ListRegionsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Region> items) {
            this.items = items;
            return this;
        }

        public ListRegionsResponse build() {
            return new ListRegionsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListRegionsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

