/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.TaggingWorkRequestErrorSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListTaggingWorkRequestErrorsResponse {
    private String opcRequestId;
    private Float retryAfter;
    private String opcNextPage;
    private List<TaggingWorkRequestErrorSummary> items;

    @ConstructorProperties(value={"opcRequestId", "retryAfter", "opcNextPage", "items"})
    ListTaggingWorkRequestErrorsResponse(String opcRequestId, Float retryAfter, String opcNextPage, List<TaggingWorkRequestErrorSummary> items) {
        this.opcRequestId = opcRequestId;
        this.retryAfter = retryAfter;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<TaggingWorkRequestErrorSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private Float retryAfter;
        private String opcNextPage;
        private List<TaggingWorkRequestErrorSummary> items;

        public Builder copy(ListTaggingWorkRequestErrorsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.retryAfter(o.getRetryAfter());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<TaggingWorkRequestErrorSummary> items) {
            this.items = items;
            return this;
        }

        public ListTaggingWorkRequestErrorsResponse build() {
            return new ListTaggingWorkRequestErrorsResponse(this.opcRequestId, this.retryAfter, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListTaggingWorkRequestErrorsResponse.Builder(opcRequestId=" + this.opcRequestId + ", retryAfter=" + this.retryAfter + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

