/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.AuthToken;
import java.beans.ConstructorProperties;

public class UpdateAuthTokenResponse {
    private String opcRequestId;
    private String etag;
    private AuthToken authToken;

    @ConstructorProperties(value={"opcRequestId", "etag", "authToken"})
    UpdateAuthTokenResponse(String opcRequestId, String etag, AuthToken authToken) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.authToken = authToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private AuthToken authToken;

        public Builder copy(UpdateAuthTokenResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.authToken(o.getAuthToken());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder authToken(AuthToken authToken) {
            this.authToken = authToken;
            return this;
        }

        public UpdateAuthTokenResponse build() {
            return new UpdateAuthTokenResponse(this.opcRequestId, this.etag, this.authToken);
        }

        public String toString() {
            return "UpdateAuthTokenResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", authToken=" + this.authToken + ")";
        }
    }
}

