/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.CustomerSecretKeySummary;
import java.beans.ConstructorProperties;

public class UpdateCustomerSecretKeyResponse {
    private String opcRequestId;
    private String etag;
    private CustomerSecretKeySummary customerSecretKeySummary;

    @ConstructorProperties(value={"opcRequestId", "etag", "customerSecretKeySummary"})
    UpdateCustomerSecretKeyResponse(String opcRequestId, String etag, CustomerSecretKeySummary customerSecretKeySummary) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.customerSecretKeySummary = customerSecretKeySummary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public CustomerSecretKeySummary getCustomerSecretKeySummary() {
        return this.customerSecretKeySummary;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private CustomerSecretKeySummary customerSecretKeySummary;

        public Builder copy(UpdateCustomerSecretKeyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.customerSecretKeySummary(o.getCustomerSecretKeySummary());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder customerSecretKeySummary(CustomerSecretKeySummary customerSecretKeySummary) {
            this.customerSecretKeySummary = customerSecretKeySummary;
            return this;
        }

        public UpdateCustomerSecretKeyResponse build() {
            return new UpdateCustomerSecretKeyResponse(this.opcRequestId, this.etag, this.customerSecretKeySummary);
        }

        public String toString() {
            return "UpdateCustomerSecretKeyResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", customerSecretKeySummary=" + this.customerSecretKeySummary + ")";
        }
    }
}

