/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.TagNamespace;
import java.beans.ConstructorProperties;

public class UpdateTagNamespaceResponse {
    private String opcRequestId;
    private TagNamespace tagNamespace;

    @ConstructorProperties(value={"opcRequestId", "tagNamespace"})
    UpdateTagNamespaceResponse(String opcRequestId, TagNamespace tagNamespace) {
        this.opcRequestId = opcRequestId;
        this.tagNamespace = tagNamespace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public TagNamespace getTagNamespace() {
        return this.tagNamespace;
    }

    public static class Builder {
        private String opcRequestId;
        private TagNamespace tagNamespace;

        public Builder copy(UpdateTagNamespaceResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.tagNamespace(o.getTagNamespace());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder tagNamespace(TagNamespace tagNamespace) {
            this.tagNamespace = tagNamespace;
            return this;
        }

        public UpdateTagNamespaceResponse build() {
            return new UpdateTagNamespaceResponse(this.opcRequestId, this.tagNamespace);
        }

        public String toString() {
            return "UpdateTagNamespaceResponse.Builder(opcRequestId=" + this.opcRequestId + ", tagNamespace=" + this.tagNamespace + ")";
        }
    }
}

