/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.TaggingWorkRequest;
import com.oracle.bmc.identity.requests.GetTaggingWorkRequestRequest;
import com.oracle.bmc.identity.responses.GetTaggingWorkRequestResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTaggingWorkRequestConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetTaggingWorkRequestConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetTaggingWorkRequestRequest interceptRequest(GetTaggingWorkRequestRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetTaggingWorkRequestRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("taggingWorkRequests").path(HttpUtils.encodePathSegment((String)request.getWorkRequestId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        return ib;
    }

    public static Function<Response, GetTaggingWorkRequestResponse> fromResponse() {
        Function<Response, GetTaggingWorkRequestResponse> transformer = new Function<Response, GetTaggingWorkRequestResponse>(){

            public GetTaggingWorkRequestResponse apply(Response rawResponse) {
                Optional retryAfterHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.GetTaggingWorkRequestResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(TaggingWorkRequest.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetTaggingWorkRequestResponse.Builder builder = GetTaggingWorkRequestResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.taggingWorkRequest((TaggingWorkRequest)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((retryAfterHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"retry-after")).isPresent()) {
                    builder.retryAfter((Float)HeaderUtils.toValue((String)"retry-after", (String)((String)((List)retryAfterHeader.get()).get(0)), Float.class));
                }
                GetTaggingWorkRequestResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

